﻿---
title: Entity Analytics dashboard
description: The Entity Analytics dashboard provides a centralized view of emerging insider threats—including host risk, user risk, service risk, and anomalies from...
url: https://www.elastic.co/docs/solutions/security/dashboards/entity-analytics-dashboard
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Entity Analytics dashboard
The Entity Analytics dashboard provides a centralized view of emerging insider threats—including host risk, user risk, service risk, and anomalies from within your network. Use it to triage, investigate, and respond to these emerging threats.
<admonition title="Requirements">
  In Elastic Stack, a [Platinum subscription](https://www.elastic.co/pricing/) or higher is required.
</admonition>

The dashboard includes the following sections:
- [Entity KPIs (key performance indicators)](#entity-kpis)
- [User Risk Scores](#entity-user-risk-scores)
- [Host Risk Scores](#entity-host-risk-scores)
- [Service Risk Scores](#service-risk-scores)
- [Entities](#entity-entities)
- [Anomalies](#entity-anomalies)


## Entity KPIs (key performance indicators)

Displays the total number of critical hosts, critical users, and anomalies. Select a link to jump to the **Hosts** page, **Users** page, or **Anomalies** table.

## User Risk Scores

<admonition title="Requirements">
  To display user risk scores, you must [turn on the risk scoring engine](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/turn-on-risk-scoring-engine).
</admonition>

Displays user risk score data for your environment, including the total number of users, and the five most recently recorded user risk scores, with their associated user names, risk data, and number of detection alerts. Like host risk scores, user risk scores are calculated using a weighted sum on a scale of 0 (lowest) to 100 (highest).
![User risk table](https://www.elastic.co/docs/solutions/images/security-user-score-data.png)

Interact with the table to filter data, view more details, and take action:
- Select the **User risk level** menu to filter the chart by the selected level.
- Click a user name link to open the entity details flyout.
- Hover over a user name link to display inline actions: **Add to timeline**, which adds the selected value to Timeline, and **Copy to Clipboard**, which copies the user name value for you to paste later.
- Click **View all** in the upper-right to display all user risk information on the Users page.
- Click the number link in the **Alerts** column to view the alerts on the Alerts page. Hover over the number and select **Investigate in timeline** (![Investigate in timeline icon](https://www.elastic.co/docs/solutions/images/security-timeline-button-osquery.png "title")) to launch Timeline with a query that includes the associated user name value.

For more information about user risk scores, refer to [Entity risk scoring](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/entity-risk-scoring).

## Host Risk Scores

<admonition title="Requirements">
  To display host risk scores, you must [turn on the risk scoring engine](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/turn-on-risk-scoring-engine).
</admonition>

Displays host risk score data for your environment, including the total number of hosts, and the five most recently recorded host risk scores, with their associated host names, risk data, and number of detection alerts. Host risk scores are calculated using a weighted sum on a scale of 0 (lowest) to 100 (highest).
![Host risk scores table](https://www.elastic.co/docs/solutions/images/security-host-score-data.png)

Interact with the table to filter data, view more details, and take action:
- Select the **Host risk level** menu to filter the chart by the selected level.
- Click a host name link to open the entity details flyout.
- Hover over a host name link to display inline actions: **Add to timeline**, which adds the selected value to Timeline, and **Copy to Clipboard**, which copies the host name value for you to paste later.
- Click **View all** in the upper-right to display all host risk information on the Hosts page.
- Click the number link in the **Alerts** column to view the alerts on the Alerts page. Hover over the number and select **Investigate in timeline** (![Investigate in timeline icon](https://www.elastic.co/docs/solutions/images/security-timeline-button-osquery.png "title")) to launch Timeline with a query that includes the associated host name value.

For more information about host risk scores, refer to [Entity risk scoring](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/entity-risk-scoring).

## Service Risk Scores

<admonition title="Requirements">
  To display service risk scores, you must [turn on the risk scoring engine](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/turn-on-risk-scoring-engine).
</admonition>

Displays service risk score data for your environment, including the total number of services, and the five most recently recorded service risk scores, with their associated service names, risk data, and number of detection alerts. Service risk scores are calculated using a weighted sum on a scale of 0 (lowest) to 100 (highest).
![Service risk scores table](https://www.elastic.co/docs/solutions/images/security-service-risk-scores.png)

Interact with the table to filter data, view more details, and take action:
- Select the **Service risk level** menu to filter the chart by the selected level.
- Click a service name link to open the service details flyout.
- Hover over a service name link to display inline actions: **Add to timeline**, which adds the selected value to Timeline, and **Copy to Clipboard**, which copies the service name value for you to paste later.
- Click the number link in the *Alerts* column to view the alerts on the Alerts page. Hover over the number and select **Investigate in timeline** (![Investigate in timeline icon](https://www.elastic.co/docs/solutions/images/security-timeline-button-osquery.png "title")) to launch Timeline with a query that includes the associated service name value.

For more information about service risk scores, refer to [Entity risk scoring](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/entity-risk-scoring).

## Entities

<admonition title="Requirements">
  To display the **Entities** section, you must [enable the entity store](/docs/solutions/security/advanced-entity-analytics/entity-store#enable-entity-store).
</admonition>

The **Entities** section provides a centralized view of all hosts, users, and services in your environment. It displays entities from the [entity store](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/entity-store), which meet any of the following criteria:
- Have been observed by Elastic Security
- Have an asset criticality assignment
- Have been added to Elastic Security through an integration, such Active Directory or Okta

<note>
  The **Entities** table only shows a subset of the data available for each entity. You can query the `.entities.v1.latest.security_user_<space-id>`, `.entities.v1.latest.security_host_<space-id>`, and `.entities.v1.latest.security_service_<space-id>` indices to see all the fields for each entity in the entity store.
</note>

![Entities section](https://www.elastic.co/docs/solutions/images/security-entities-section.png)

Entity data from different sources appears in the **Entities** section based on the following timelines:
- When you first enable the entity store, only data stored in the last 24 hours is processed. After that, data is processed continuously.
- Observed events from the Elastic Security default data view are processed in near real-time.
- Entity Analytics data, such as entity risk scores and asset criticality (including bulk asset criticality upload), is also processed in near real-time.
- The availability of entities extracted from Entity Analytics integrations depends on the specific integration. Refer to [Active Directory Entity Analytics](https://docs.elastic.co/en/integrations/entityanalytics_ad), [Microsoft Entra ID Entity Analytics](https://docs.elastic.co/en/integrations/entityanalytics_entra_id), and [Okta Entity Analytics](https://docs.elastic.co/en/integrations/entityanalytics_okta) for more details.

Interact with the table to filter data and view more details:
- Select the **Risk level** dropdown to filter the table by the selected user, host, or service risk level.
- Select the **Criticality** dropdown to filter the table by the selected asset criticality level.
- Select the **Source** dropdown to filter the table by the data source.
- Click the **View details** icon (![View details icon](https://www.elastic.co/docs/solutions/images/security-view-details-icon.png "title")) to open the entity details flyout.


## Anomalies

Anomaly detection jobs identify suspicious or irregular behavior patterns. The Anomalies table displays the total number of anomalies identified by these prebuilt machine learning jobs (named in the **Anomaly name** column).
<admonition title="Requirements">
  To display anomaly results, you must [install and run](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs) one or more [prebuilt anomaly detection jobs](https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-siem). You cannot add custom anomaly detection jobs to the Entity Analytics dashboard.
</admonition>

![Anomalies table](https://www.elastic.co/docs/solutions/images/security-anomalies-table.png)

Interact with the table to view more details:
- Click **View all host anomalies** to go to the Anomalies table on the Hosts page.
- Click **View all user anomalies** to go to the Anomalies table on the Users page.
- Click **View all** to display and manage all machine learning jobs on the Anomaly Detection Jobs page.

<tip>
  To learn more about machine learning, refer to [What is Elastic machine learning?](https://www.elastic.co/docs/explore-analyze/machine-learning)
</tip>