﻿---
title: Prevent Elastic Agent uninstallation
description: For hosts enrolled in Elastic Defend, you can add a layer of security by enabling Agent tamper protection on the Elastic Agent policy. This helps prevent...
url: https://www.elastic.co/docs/solutions/security/configure-elastic-defend/prevent-elastic-agent-uninstallation
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Prevent Elastic Agent uninstallation
For hosts enrolled in Elastic Defend, you can add a layer of security by enabling **Agent tamper protection** on the Elastic Agent policy. This helps prevent casual users from bypassing or disabling Elastic Defend's endpoint protections.
When this setting is enabled, the `uninstall` CLI command for Elastic Agent and Elastic Endpoint requires a unique uninstall token. One unique uninstall token is generated per Elastic Agent policy, and you can retrieve uninstall tokens in an Elastic Agent policy’s settings or in the Fleet UI.
<note>
  Tamper protection is a defense-in-depth capability that does not provide comprehensive protection against all administrative attacks. Administrators are in control of the security of a device and can change core OS settings, alter key system files, uninstall security patches, or even replace the OS entirely. To prevent users from uninstalling or sabotaging Elastic Defend, avoid granting them administrative privileges.
</note>

<admonition title="Requirements">
  - In Elastic Stack, agent tamper protection requires a [Platinum or higher subscription](https://www.elastic.co/pricing).
  - In Serverless, agent tamper protection requires the Endpoint Protection Complete [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
  - Hosts must be enrolled in the Elastic Defend integration.
  - Elastic Agents must be version 8.11.0 or later.
  - This feature is supported for all operating systems.
</admonition>

![Agent tamper protection setting highlighted on Agent policy settings page](https://www.elastic.co/docs/solutions/images/security-agent-tamper-protection.png)


## Enable Agent tamper protection

You can enable Agent tamper protection by configuring the Elastic Agent policy.
1. Find **Fleet** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select **Agent policies**, then select the Agent policy you want to configure.
3. Select the **Settings** tab on the policy details page.
4. In the **Agent tamper protection** section, turn on the **Prevent agent tampering** setting.
   This makes the **Get uninstall command** link available, which you can follow to get the uninstall token and CLI command if you need to [uninstall an Agent](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/uninstall-elastic-agent) on this policy.
   <tip>
   You can also access an Agent policy’s uninstall tokens on the **Uninstall tokens** tab on the **Fleet** page. Refer to [Access uninstall tokens](#fleet-uninstall-tokens) for more information.
   </tip>
5. Select **Save changes**.


## Access uninstall tokens

If you need the uninstall token to remove Elastic Agent from an endpoint, you can find it in several ways:
- **On the Agent policy**: Go to the Agent policy’s **Settings** tab, then click the **Get uninstall command** link. The **Uninstall agent** flyout opens, containing the full uninstall command with the token.
- **On the Fleet page**: Select **Uninstall tokens** for a list of the uninstall tokens generated for your Agent policies. You can:
  - Click the **Show token** icon in the **Token** column to reveal a specific token.
- Click the **View uninstall command** icon in the **Actions** column to open the **Uninstall agent** flyout, containing the full uninstall command with the token.

<tip>
  If you have many tamper-protected Elastic Agent policies, you may want to [provide multiple uninstall tokens](/docs/solutions/security/configure-elastic-defend/uninstall-elastic-agent#multiple-uninstall-tokens) in a single command.
</tip>