﻿---
title: Install the Elastic Defend integration
description: Like other Elastic integrations, Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic...
url: https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Install the Elastic Defend integration
Like other Elastic integrations, Elastic Defend is integrated into the Elastic Agent using [Fleet](https://www.elastic.co/docs/reference/fleet). Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.
<admonition title="Requirements">
  - Fleet is required for Elastic Defend.
  - To configure the Elastic Defend integration on the Elastic Agent, you must have permission to use Fleet in Kibana.
  - In Elastic Stack, you must have the **Elastic Defend Policy Management : All** [privilege](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/elastic-defend-feature-privileges) to configure an integration policy, and the **Endpoint List** [privilege](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/elastic-defend-feature-privileges) to access the **Endpoints** page.
  - In Serverless, you must have the appropriate user role to configure an integration policy and access the **Endpoints** page.
</admonition>


## Before you begin

If you’re using macOS, some versions may require you to grant Full Disk Access to different kernels, system extensions, or files. Refer to [Elastic Defend requirements](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/elastic-defend-requirements) for more information.
<note>
  Elastic Defend does not support deployment within an Elastic Agent DaemonSet in Kubernetes.
</note>


## Add the Elastic Defend integration

1. Find **Integrations** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
   ![Search result for "Elastic Defend" on the Integrations page.](https://www.elastic.co/docs/solutions/images/security-endpoint-cloud-sec-integrations-page.png)
2. Search for and select **Elastic Defend**, then select **Add Elastic Defend**. The integration configuration page appears.
   <note>
   If this is the first integration you’ve installed and the **Ready to add your first integration?** page appears instead, select **Add integration only (skip agent installation)** to proceed. You can [install Elastic Agent](#enroll-agent) after setting up the Elastic Defend integration.
   </note>
   ![Add Elastic Defend integration page](https://www.elastic.co/docs/solutions/images/security-endpoint-cloud-security-configuration.png)
3. Configure the Elastic Defend integration with an **Integration name** and optional **Description**.
4. Select the type of environment you want to protect, either **Traditional Endpoints** or **Cloud Workloads**.
5. Select a configuration preset. Each preset comes with different default settings for Elastic Agent — you can further customize these later by [configuring the Elastic Defend integration policy](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/configure-an-integration-policy-for-elastic-defend).
   |                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
   |----------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
   | **Traditional Endpoint presets** | All traditional endpoint presets *except **Data Collection** have these preventions enabled by default: malware, ransomware, memory threat, malicious behavior, and credential theft. Each preset collects the following events:- **Data Collection:** All events; no preventions- **Next-Generation Antivirus (NGAV):** Process events; all preventions- **Essential EDR (Endpoint Detection & Response):** Process, Network, File events; all preventions- **Complete EDR (Endpoint Detection & Response):** All events; all preventions                                                                |
   | **Cloud Workloads presets**      | Both cloud workload presets are intended for monitoring cloud-based Linux hosts. Therefore, [session data](https://www.elastic.co/docs/solutions/security/investigate/session-view) collection, which enriches process events, is enabled by default. They both have all preventions disabled by default, and collect process, network, and file events.- **All events:** Includes data from automated sessions.- **Interactive only:** Filters out data from non-interactive sessions by creating an [event filter](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/event-filters). |
6. Enter a name for the agent policy in **New agent policy name**. If other agent policies already exist, you can click the **Existing hosts** tab and select an existing policy instead. For more details on Elastic Agent configuration settings, refer to [Elastic Agent policies](https://www.elastic.co/docs/reference/fleet/agent-policy).
7. When you’re ready, click **Save and continue**.
8. To complete the integration, select **Add Elastic Agent to your hosts** and continue to the next section to install the Elastic Agent on your hosts.


## Configure and enroll the Elastic Agent

To enable the Elastic Defend integration, you must enroll agents in the relevant policy using Fleet.
<important>
  Before you add an Elastic Agent, a Fleet Server must be running. Refer to [Add a Fleet Server](https://www.elastic.co/docs/reference/fleet/deployment-models).Elastic Defend cannot be integrated with an Elastic Agent in standalone mode.
</important>


### Important information about Fleet Server

<applies-to>
  - Elastic Stack: Generally available
</applies-to>

<note>
  If you are running an Elastic Stack version earlier than 7.13.0, you can skip this section.
</note>

If you have upgraded to an Elastic Stack version that includes Fleet Server 7.13.0 or newer, you will need to redeploy your agents. Review the following scenarios to ensure you take the appropriate steps.
- If you redeploy the Elastic Agent to the same machine through the Fleet application after you upgrade, a new agent will appear.
- If you want to remove the Elastic Agent entirely without transitioning to the Fleet Server, then you will need to manually uninstall the Elastic Agent on the machine. This will also uninstall the endpoint. Refer to [Uninstall Elastic Agent](https://www.elastic.co/docs/reference/fleet/uninstall-elastic-agent).
- In the rare event that the Elastic Agent fails to uninstall, you might need to manually uninstall the endpoint. Refer to [Uninstall an endpoint](/docs/solutions/security/configure-elastic-defend/uninstall-elastic-agent#uninstall-endpoint) at the end of this topic.


### Add the Elastic Agent

1. If you’re in the process of installing an Elastic Agent integration (such as Elastic Defend), the **Add agent** UI opens automatically. Otherwise, find **Fleet** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), and select **Agents** → **Add agent**.
   ![Add agent flyout on the Fleet page.](https://www.elastic.co/docs/solutions/images/security-endpoint-cloud-sec-add-agent.png)
2. Select an agent policy for the Elastic Agent. You can select an existing policy, or select **Create new agent policy** to create a new one. For more details on Elastic Agent configuration settings, refer to [Elastic Agent policies](https://www.elastic.co/docs/reference/fleet/agent-policy).
   The selected agent policy should include the integration you want to install on the hosts covered by the agent policy (in this example, Elastic Defend).
   ![Add agent flyout with Elastic Defend integration highlighted.](https://www.elastic.co/docs/solutions/images/security-endpoint-cloud-sec-add-agent-detail.png)
3. Ensure that the **Enroll in Fleet** option is selected. Elastic Defend cannot be integrated with Elastic Agent in standalone mode.
4. Select the appropriate platform or operating system for the host, then copy the provided commands.
5. On the host, open a command-line interface and navigate to the directory where you want to install Elastic Agent. Paste and run the commands from Fleet to download, extract, enroll, and start Elastic Agent.
6. (Optional) Return to the **Add agent** flyout in Fleet, and observe the **Confirm agent enrollment** and **Confirm incoming data** steps automatically checking the host connection. It may take a few minutes for data to arrive in Elasticsearch.
7. After you have enrolled the Elastic Agent on your host, you can click **View enrolled agents** to access the list of agents enrolled in Fleet. Otherwise, select **Close**.
   The host will now appear on the **Endpoints** page in the Elastic Security app. It may take another minute or two for endpoint data to appear in Elastic Security.
8. For macOS, continue with [these instructions](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/enable-access-for-macos) to grant Elastic Endpoint the required permissions.