﻿---
title: Elastic Defend feature privileges
description: You can create user roles and define privileges to manage feature access in Elastic Security. This allows you to use the principle of least privilege...
url: https://www.elastic.co/docs/solutions/security/configure-elastic-defend/elastic-defend-feature-privileges
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Defend feature privileges
You can create user roles and define privileges to manage feature access in Elastic Security. This allows you to use the principle of least privilege while managing access to Elastic Defend's features.
To configure roles and privileges, find **Roles** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). For more details on using this UI, refer to [Role management using Kibana](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-role-management) for Elastic Stack, or to [Custom roles](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles) for Serverless.
<note>
  <applies-to>Elastic Stack: Generally available since 9.1</applies-to> Elastic Defend's feature privileges can be assigned on a per-space basis. For more information, refer to [Spaces and Elastic Defend FAQ](https://www.elastic.co/docs/solutions/security/get-started/spaces-defend-faq).
</note>

To grant access, select **All** for the **Security** feature in the **Assign role to space** configuration UI, then turn on the **Customize sub-feature privileges** switch.
<important>
  Selecting **All** for the overall **Security** feature does NOT enable any sub-features. You must also enable the **Customize sub-feature privileges** switch, and then enable each sub-feature privilege individually.
</important>

For each of the following sub-feature privileges, select the type of access you want to allow:
- **All**: Users have full access to the feature, which includes performing all available actions and managing configuration.
- **Read**: Users can view the feature, but can’t perform any actions or manage configuration (some features don’t have this privilege).
- **None**: Users can’t access or view the feature.


|                                                                                                                                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                    |
|----------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Endpoint List**                                                                                                                                                    | Access the [Endpoints](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/endpoints) page, which lists all hosts running Elastic Defend, and associated integration details.                                                                                                                                                                                                                     |
| **Automatic Troubleshooting**                                                                                                                                        | Access [Automatic Troubleshooting](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/automatic-troubleshooting) to check if your hosts have third-party AV software installed.**Note:** In Elastic Stack 9.0.0, this privilege is called **Endpoint Insights**.                                                                                                                                 |
| **Global Artifact Management** <applies-to>Elastic Stack: Generally available since 9.1</applies-to>                                                                 | Manage global assignment of endpoint artifacts (e.g., trusted applications, event filters) across all spaces and policies. This privilege controls global assignment rights only; privileges for each artifact type are required for full artifact management.                                                                                                                                                     |
| **Trusted Applications**                                                                                                                                             | Access the [Trusted applications](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/trusted-applications) page to remediate conflicts with other software, such as antivirus or endpoint security applications.                                                                                                                                                                                 |
| **Trusted Devices** <applies-to>Elastic Stack: Generally available since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to>     | Access the [Trusted devices](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/trusted-devices) page to specify which trusted devices can connect to hosts with [Device Control](/docs/solutions/security/configure-elastic-defend/configure-an-integration-policy-for-elastic-defend#device-control) enabled.                                                                                  |
| **Host Isolation Exceptions**                                                                                                                                        | Access the [Host isolation exceptions](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/host-isolation-exceptions) page to add specific IP addresses that isolated hosts can still communicate with.                                                                                                                                                                                           |
| **Blocklist**                                                                                                                                                        | Access the [Blocklist](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/blocklist) page to prevent specified applications from running on hosts, extending the list of processes that Elastic Defend considers malicious.                                                                                                                                                                      |
| **Event Filters**                                                                                                                                                    | Access the [Event Filters](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/event-filters) page to filter out endpoint events that you don’t want stored in Elasticsearch.                                                                                                                                                                                                                     |
| **Endpoint Exceptions** <applies-to>Elastic Stack: Generally available since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> | Add and use [endpoint exceptions](/docs/solutions/security/detect-and-alert/add-manage-exceptions#endpoint-rule-exceptions).**Note:** In Elastic Stack 9.1.0 and earlier, this privilege is included within the **Security** privilege.                                                                                                                                                                            |
| **Elastic Defend Policy Management**                                                                                                                                 | Access the [Policies](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/policies) page and Elastic Defend integration policies to configure protections, event collection, and advanced policy features.                                                                                                                                                                                        |
| **Response Actions History**                                                                                                                                         | Access the [response actions history](https://www.elastic.co/docs/solutions/security/endpoint-response-actions/response-actions-history) for endpoints.                                                                                                                                                                                                                                                            |
| **Host Isolation**                                                                                                                                                   | Allow users to [isolate and release hosts](https://www.elastic.co/docs/solutions/security/endpoint-response-actions/isolate-host).                                                                                                                                                                                                                                                                                 |
| **Process Operations**                                                                                                                                               | Perform host process-related [response actions](https://www.elastic.co/docs/solutions/security/endpoint-response-actions), including `processes`, `kill-process`, and `suspend-process`.                                                                                                                                                                                                                           |
| **File Operations**                                                                                                                                                  | Perform file-related [response actions](https://www.elastic.co/docs/solutions/security/endpoint-response-actions) in the response console.                                                                                                                                                                                                                                                                         |
| **Execute Operations**                                                                                                                                               | Perform shell commands and script-related [response actions](https://www.elastic.co/docs/solutions/security/endpoint-response-actions) in the response console.The commands are run on the host using the same user account running the Elastic Defend integration, which normally has full control over the system. Only grant this feature privilege to Elastic Security users who require this level of access. |
| **Scan Operations**                                                                                                                                                  | Perform folder scan [response actions](https://www.elastic.co/docs/solutions/security/endpoint-response-actions) in the response console.                                                                                                                                                                                                                                                                          |


## Upgrade considerations

<applies-to>
  - Elastic Stack: Generally available
</applies-to>

After upgrading from Elastic Security 8.6 or earlier, existing user roles will be assigned **None** by default for any new endpoint management feature privileges, and you’ll need to explicitly assign them. However, many features previously required the built-in `superuser` role, and users who previously had this role will still have it after upgrading.
You’ll probably want to replace the broadly permissive `superuser` role with more focused feature-based privileges to ensure that users have access to only the specific features that they need. Refer to [Kibana role management](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles) for more details on assigning roles and privileges.