﻿---
title: Configure self-healing rollback for Windows endpoints
description: Elastic Defend's self-healing feature rolls back file changes on Windows endpoints when a prevention alert is generated by enabled protection features...
url: https://www.elastic.co/docs/solutions/security/configure-elastic-defend/configure-self-healing-rollback-for-windows-endpoints
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Configure self-healing rollback for Windows endpoints
Elastic Defend's self-healing feature rolls back file changes on Windows endpoints when a prevention alert is generated by enabled protection features. File changes that occurred on the host within five minutes before the prevention alert will revert to their previous state (which may be up to two hours before the alert).
This can help contain the impact of malicious activity, as Elastic Defend not only stops the activity but also erases any attack artifacts deployed prior to detection.
<admonition title="Requirements">
  - Self-healing rollback is only supported for Windows endpoints.
  - In Elastic Stack, this feature requires a [Platinum or Enterprise subscription](https://www.elastic.co/pricing).
  - In Serverless, this feature requires the Endpoint Protection Complete [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
</admonition>

<warning>
  This feature can cause permanent data loss since it overwrites recent changes and deletes recently added files on the host. Self-healing rollback targets the changes related to a detected threat, but may also include incidental actions that aren’t directly related to the threat.Also, rollback is triggered by *every* Elastic Defend prevention alert, so you should tune your system to eliminate false positives before enabling this feature.
</warning>

1. Find **Policies** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), then select the integration policy you want to configure.
2. Scroll down to the bottom of the policy and click **Show advanced settings**.
3. Enter `true` for the setting `windows.advanced.alerts.rollback.self_healing.enabled`.
4. Click **Save**.