﻿---
title: Configure an integration policy for Elastic Defend
description: After the Elastic Agent is installed with the Elastic Defend integration, several protections features — including preventions against malware, ransomware,...
url: https://www.elastic.co/docs/solutions/security/configure-elastic-defend/configure-an-integration-policy-for-elastic-defend
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Configure an integration policy for Elastic Defend
After the Elastic Agent is installed with the Elastic Defend integration, several protections features — including preventions against malware, ransomware, memory threats, and malicious behavior — are automatically enabled on protected hosts. If needed, you can update the integration policy to configure protection settings, event collection, antivirus settings, trusted applications, trusted devices, event filters, host isolation exceptions, and blocked applications to meet your organization’s security needs.
You can also create multiple Elastic Defend integration policies to maintain unique configuration profiles. To create an additional Elastic Defend integration policy, find **Integrations** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), then follow the steps for [adding the Elastic Defend integration](/docs/solutions/security/configure-elastic-defend/install-elastic-defend#add-security-integration).
<admonition title="Requirements">
  To configure an integration policy:
  - In Elastic Stack, you must have the **Elastic Defend Policy Management : All** [privilege](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/elastic-defend-feature-privileges).
  - In Serverless, you must have the appropriate user role.
</admonition>

<tip>
  In addition to configuring an Elastic Defend policy through the Elastic Security UI, you can create and customize an Elastic Defend policy [through the API](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/create-an-elastic-defend-policy-using-api).
</tip>


## How Elastic Defend protections work

Elastic Defend is an endpoint security solution with multiple layers of protections that work in tandem to detect and stop threats. This differs from traditional antivirus software, which typically relies on a single layer of pre-execution file scanning.
Elastic Defend's protection layers include:
- **Pre-execution protections**: Some layers, like [malware protection](#malware-protection), operate before execution — as soon as a threat is introduced to the file system, it's scanned and can be blocked before it ever runs.
- **Post-execution protections**: Most layers operate after a threat launches or executes. These include [memory threat protection](#memory-protection) and [malicious behavior protection](#behavior-protection), which monitor running processes for suspicious activity and in-memory threats that can evade traditional file-based detection.

This layered approach means that even if a threat bypasses one protection layer, other layers can still detect and stop it once it runs. In a realistic attack scenario, Elastic Defend comprehensively detects and stops the attack in its tracks, even when malicious activity begins after a user interacts with a threat.

## Configure policy settings

To configure an integration policy:
1. Find **Policies** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select the integration policy you want to configure. The integration policy configuration page appears.
3. On the **Policy settings** tab, review and configure the following settings as appropriate:
   - [Malware protection](#malware-protection)
- [Ransomware protection](#ransomware-protection)
- [Memory threat protection](#memory-protection)
- [Malicious behavior protection](#behavior-protection)
- [Attack surface reduction](#attack-surface-reduction)
- [Device control](#device-control)
- [Event collection](#event-collection)
- [Register Elastic Security as antivirus (optional)](#register-as-antivirus)
- [Advanced policy settings (optional)](#adv-policy-settings)
- [Save the general policy settings](#save-policy)
4. Click the **Trusted applications**, **Trusted devices**, **Event filters**, **Host isolation exceptions**, and **Blocklist** tabs to review the endpoint policy artifacts assigned to this integration policy (for more information, refer to [Trusted applications](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/trusted-applications), [Trusted devices](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/trusted-devices), [Event filters](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/event-filters), [Host isolation exceptions](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/host-isolation-exceptions), and [Blocklist](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/blocklist)). On these tabs, you can:
   - Expand and view an artifact: Click the arrow next to its name.
- View an artifact’s details: Click the actions menu (**…**), then select **View full details**.
- Unassign an artifact: Click the actions menu (**…**), then select **Remove from policy**. This does not delete the artifact; this just unassigns it from the current policy.
- Assign an existing artifact: Click **Assign *x* to policy**, then select an item from the flyout. This view lists any existing artifacts that aren’t already assigned to the current policy.
   <note>
   You can’t create a new endpoint policy artifact while configuring an integration policy. To create a new artifact, go to its main page in the Elastic Security app (for example, to create a new trusted application, find **Trusted applications** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects)).
   </note>
5. Click the **Protection updates** tab to configure how Elastic Defend receives updates from Elastic with the latest threat detections, malware models, and other protection artifacts. Refer to [Configure updates for protection artifacts](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/configure-updates-for-protection-artifacts) for more information.


## Malware protection

Elastic Defend malware prevention detects and stops malicious attacks by using a machine learning model that looks for static attributes to determine if a file is malicious or benign.
By default, malware protection is enabled on Windows, macOS, and Linux hosts. To disable malware protection, turn off the **Malware protections** toggle.
<admonition title="Requirements">
  In Serverless, malware protection requires the Endpoint Protection Essentials [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
</admonition>

Malware protection levels are:
- **Detect**: Detects malware on the host and generates an alert. The agent will **not** block malware. You must pay attention to and analyze any malware alerts that are generated.
- **Prevent** (Default): Detects malware on the host, blocks it from executing, and generates an alert.

These additional options are available for malware protection:
- **Blocklist**: Enable or disable the [blocklist](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/blocklist) for all hosts associated with this Elastic Defend policy. The blocklist allows you to prevent specified applications from running on hosts, extending the list of processes that Elastic Defend considers malicious.
- **Scan files upon modification**: By default, Elastic Defend scans files every time they’re modified, which can be resource-intensive on hosts where files are frequently modified, such as servers and developer machines. Turn off this option to only scan files when they’re executed. Elastic Defend will continue to identify malware as it attempts to run, providing a robust level of protection while improving endpoint performance.

Select **Notify user** to send a push notification in the host operating system when activity is detected or prevented. Notifications are enabled by default for the **Prevent** option.
<tip>
  If you have the appropriate license or project feature tier, you can customize these notifications using the `Elastic Security {action} {filename}` syntax.
</tip>

![Detail of malware protection section.](https://www.elastic.co/docs/solutions/images/security-malware-protection.png)


### Manage quarantined files

When **Prevent** is enabled for malware protection, Elastic Defend will quarantine any malicious file it finds (this includes files defined in the [blocklist](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/blocklist)). Specifically, Elastic Defend will remove the file from its current location, apply a rolling XOR with the key `ELASTIC`, move it to a different folder, and rename it as a GUID string, such as `318e70c2-af9b-4c3a-939d-11410b9a112c`.
The quarantine folder location varies by operating system:
- macOS: `/System/Volumes/Data/.equarantine`
- Linux: `.equarantine` at the root of the mount point of the file being quarantined
- Windows - Elastic Defend versions 8.5 and later: `[DriveLetter:]\.equarantine`, unless the files are from the `C:` drive. These files are moved to `C:\Program Files\Elastic\Endpoint\state\.equarantine`.
- Windows - Elastic Defend versions 8.4 and earlier: `[DriveLetter:]\.equarantine`, for any drive

To restore a quarantined file to its original state and location, [add an exception](https://www.elastic.co/docs/solutions/security/detect-and-alert/add-manage-exceptions) to the rule that identified the file as malicious. If the exception would’ve stopped the rule from identifying the file as malicious, Elastic Defend restores the file.
You can access a quarantined file by using the `get-file` [response action command](/docs/solutions/security/endpoint-response-actions#response-action-commands) in the response console. To do this, copy the path from the alert’s **Quarantined file path** field (`file.Ext.quarantine_path`), which appears under **Highlighted fields** in the alert details flyout. Then paste the value into the `--path` parameter. This action doesn’t restore the file to its original location, so you will need to do this manually.
<important>
  When you retrieve a quarantined file using `get-file`, the XOR obfuscation is automatically reversed, and the original malicious file is retrieved.
</important>

<note>
  - In Elastic Stack, response actions and the response console UI are [Enterprise subscription](https://www.elastic.co/pricing) features.
  - In Serverless, response actions and the response console UI are Endpoint Protection Complete [project features](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
</note>


## Ransomware protection

Behavioral ransomware prevention detects and stops ransomware attacks on Windows systems by analyzing data from low-level system processes. It is effective across an array of widespread ransomware families — including those targeting the system’s master boot record.
<admonition title="Requirements">
  - In Elastic Stack, ransomware protection is enabled by default if you have a [Platinum or Enterprise license](https://www.elastic.co/pricing). If you upgrade to a Platinum or Enterprise license from Basic or Gold, ransomware protection will be disabled by default.
  - In Serverless, ransomware protection requires the Endpoint Protection Essentials [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
</admonition>

Ransomware protection levels are:
- **Detect**: Detects ransomware on the host and generates an alert. Elastic Defend will **not** block ransomware. You must pay attention to and analyze any ransomware alerts that are generated.
- **Prevent** (Default): Detects ransomware on the host, blocks it from executing, and generates an alert.

When ransomware protection is enabled, canary files placed in targeted locations on your hosts provide an early warning system for potential ransomware activity. When a canary file is modified, Elastic Defend immediately generates a ransomware alert. If **prevent** ransomware is active, Elastic Defend terminates the process that modified the file.
Select **Notify user** to send a push notification in the host operating system when activity is detected or prevented. Notifications are enabled by default for the **Prevent** option.
<tip>
  If you have the appropriate license or project feature tier, you can customize these notifications using the `Elastic Security {action} {filename}` syntax.
</tip>

![Detail of ransomware protection section.](https://www.elastic.co/docs/solutions/images/security-ransomware-protection.png)


## Memory threat protection

Memory threat protection detects and stops in-memory threats, such as shellcode injection, which are used to evade traditional file-based detection techniques.
<admonition title="Requirements">
  - In Elastic Stack, memory threat protection is enabled by default if you have a [Platinum or Enterprise license](https://www.elastic.co/pricing). If you upgrade to a Platinum or Enterprise license from Basic or Gold, memory threat protection will be disabled by default.
  - In Serverless, memory threat protection requires the Endpoint Protection Essentials [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
</admonition>

Memory threat protection levels are:
- **Detect**: Detects memory threat activity on the host and generates an alert. Elastic Defend will **not** block the in-memory activity. You must pay attention to and analyze any alerts that are generated.
- **Prevent** (Default): Detects memory threat activity on the host, forces the process or thread to stop, and generates an alert.

Select **Notify user** to send a push notification in the host operating system when activity is detected or prevented. Notifications are enabled by default for the **Prevent** option.
<tip>
  If you have the appropriate license or project feature tier, you can customize these notifications using the `Elastic Security {action} {rule}` syntax.
</tip>

![Detail of memory protection section.](https://www.elastic.co/docs/solutions/images/security-memory-protection.png)


## Malicious behavior protection

Malicious behavior protection detects and stops threats by monitoring the behavior of system processes for suspicious activity. Behavioral signals are much more difficult for adversaries to evade than traditional file-based detection techniques.
<admonition title="Requirements">
  - In Elastic Stack, malicious behavior protection is enabled by default if you have a [Platinum or Enterprise license](https://www.elastic.co/pricing). If you upgrade to a Platinum or Enterprise license from Basic or Gold, malicious behavior protection will be disabled by default.
  - In Serverless, malicious behavior protection requires the Endpoint Protection Essentials [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
</admonition>

Malicious behavior protection levels are:
- **Detect**: Detects malicious behavior on the host and generates an alert. Elastic Defend will **not** block the malicious behavior. You must pay attention to and analyze any alerts that are generated.
- **Prevent** (Default): Detects malicious behavior on the host, forces the process to stop, and generates an alert.

Select whether you want to use **Reputation service** for additional protection. Elastic’s reputation service leverages our extensive threat intelligence knowledge to make high confidence real-time prevention decisions. For example, reputation service can detect suspicious downloads of binaries with low or malicious reputation. Endpoints communicate with the reputation service directly at [[https://cloud.security.elastic.co](https://cloud.security.elastic.co)](https://cloud.security.elastic.co).
<note>
  In Elastic Stack, reputation service requires an active [Platinum or Enterprise subscription](https://www.elastic.co/pricing) and is available on cloud deployments only.
</note>

Select **Notify user** to send a push notification in the host operating system when activity is detected or prevented. Notifications are enabled by default for the **Prevent** option.
<tip>
  If you have the appropriate license or project feature tier, you can customize these notifications using the `Elastic Security {action} {rule}` syntax.
</tip>

![Detail of behavior protection section.](https://www.elastic.co/docs/solutions/images/security-behavior-protection.png)


## Attack surface reduction

This section helps you reduce vulnerabilities that attackers can target on Windows endpoints.
<admonition title="Requirements">
  In Serverless, attack surface reduction requires the Endpoint Protection Essentials [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
</admonition>

**Credential hardening**: Prevents attackers from stealing credentials stored in Windows system process memory. Turn on the toggle to remove any overly permissive access rights that aren’t required for standard interaction with the Local Security Authority Subsystem Service (LSASS). This feature enforces the principle of least privilege without interfering with benign system activity that is related to LSASS.
![Detail of attack surface reduction section.](https://www.elastic.co/docs/solutions/images/security-attack-surface-reduction.png)


## Device control

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
</applies-to>

Device control helps protect your Windows and Mac endpoints from data loss, malware, and unauthorized access by managing which devices can connect to your computers. Specifically, it restricts which external USB storage devices can connect to hosts that have Elastic Defend installed.
<important>
  Device control only affects external USB storage devices. It does not affect other peripherals such as Yubikeys, webcams, or keyboards.
</important>

To configure device control for one or more hosts, edit the Elastic Defend policy that affects those hosts. Your policy specifies which operations these devices are allowed to take on a host. You can create [trusted devices](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/trusted-devices) to define exceptions to your policy for specific devices.
![Detail of device control section.](https://www.elastic.co/docs/solutions/images/security-defend-policy-device-control.png)

By default, each Kibana instance includes a Device Control dashboard. When at least one of your Elastic Defend policies has device control enabled, the dashboard displays data about attempted device connections and their outcomes. To access it and review information about blocked connections, search for `device control` in the **Dashboards** page's **Custom Dashboards** section.
<important>
  To collect device control data, Elastic Defend must be updated to at least version 9.2.0. Until you update it to this version, the device control dashboard will not appear and device control events will not be ingested. Device control blocking will still work.
</important>


## Event collection

In the **Settings** section, select which categories of events to collect on each operating system. Most categories are collected by default.
![Detail of event collection section.](https://www.elastic.co/docs/solutions/images/security-event-collection.png)


## Register Elastic Security as antivirus (optional)

You can register Elastic Security as your hosts' antivirus software by enabling **Register as antivirus**.
<note>
  Windows Server versions are not supported. Antivirus registration requires Windows Security Center, which is not included in Windows Server operating systems.
</note>

By default, the **Sync with malware protection level** is selected to automatically set antivirus registration to match how you’ve configured Elastic Defend's [malware protection](#malware-protection). If malware protection is turned on *and* set to **Prevent**, antivirus registration will also be enabled; in any other case, antivirus registration will be disabled.
If you don’t want to sync antivirus registration, you can set it manually with **Enabled** or **Disabled**.
![Detail of Register as antivirus option.](https://www.elastic.co/docs/solutions/images/security-register-as-antivirus.png)


## Advanced policy settings (optional)

Users with unique configuration and security requirements can select **Show advanced settings** while configuring an Elastic Defend integration policy to support advanced use cases. Hover over each setting to view a short description or refer to [Elastic Defend advanced settings](https://www.elastic.co/docs/reference/security/defend-advanced-settings) for more detailed explanations.
<note>
  Advanced settings are not recommended for most users.
</note>

This section includes:
- [Turn off diagnostic data for Elastic Defend](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/turn-off-diagnostic-data-for-elastic-defend)
- [Configure self-healing rollback for Windows endpoints](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/configure-self-healing-rollback-for-windows-endpoints)
- [Configure Linux file system monitoring](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/configure-linux-file-system-monitoring)
- [Configure data volume](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/configure-data-volume-for-elastic-endpoint)


## Save the general policy settings

After you have configured the general settings on the **Policy settings** tab, click **Save**. A confirmation message appears.