﻿---
title: Security posture management overview
description: Elastic’s Cloud Security Posture Management (CSPM) and Kubernetes Security Posture Management (KSPM) features help you discover and evaluate the services...
url: https://www.elastic.co/docs/solutions/security/cloud/security-posture-management-overview
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Security posture management overview
## Overview

Elastic’s [Cloud Security Posture Management](https://www.elastic.co/docs/solutions/security/cloud/cloud-security-posture-management) (CSPM) and [Kubernetes Security Posture Management](https://www.elastic.co/docs/solutions/security/cloud/kubernetes-security-posture-management) (KSPM) features help you discover and evaluate the services and resources in your cloud environment — like storage, compute, IAM, and more — against security guidelines defined by the Center for Internet Security (CIS). They help you identify and remediate configuration risks that could undermine the confidentiality, integrity, and availability of your cloud assets, such as publicly exposed storage buckets or overly permissive networking objects.
The KSPM feature assesses the security of your Kubernetes assets, while the CSPM feature assesses the security of your AWS resources such as storage, compute, IAM, and more.

## Getting started

For setup instructions, refer to:
- [Get started with KSPM](https://www.elastic.co/docs/solutions/security/cloud/kubernetes-security-posture-management)
- [Get started with CSPM](https://www.elastic.co/docs/solutions/security/cloud/get-started-with-cspm-for-aws)


## Use cases

Using the data generated by these features, you can:
**Identify and secure misconfigured infrastructure:**
1. Find **Cloud Security Posture** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **View all failed findings**, either for an individual resource or a group of resources.
3. Click a failed finding to open the Findings flyout.
4. Follow the steps under Remediation to fix the misconfiguration.

**Identify the CIS Sections (security best practice categories) with which your resources are least compliant:**
1. Find **Cloud Security Posture** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Do one of the following:
   1. Under Failed findings by CIS section, click the name of a CIS section to view all failed findings from that section.
2. Go to the **Findings** page and filter by the `rule.section` field. For example, search for `rule.section : API Server` to view findings from the API Server category.

**Identify your least compliant cloud resources**
1. Go to the **Findings** page.
2. Click the **Group by** menu near the search box, and select **Resource** to sort resources by their number of failed findings.
3. Click a resource ID to view associated findings.