﻿---
title: Get started with CNVM
description: This page explains how to set up Cloud Native Vulnerability Management (CNVM). Elastic Stack users: Elastic Stack version 8.8 or higher and an appropriate...
url: https://www.elastic.co/docs/solutions/security/cloud/get-started-with-cnvm
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 8.8
---

# Get started with CNVM
This page explains how to set up Cloud Native Vulnerability Management (CNVM).

## Requirements

- Elastic Stack users: Elastic Stack version 8.8 or higher and an [appropriate subscription](https://www.elastic.co/pricing) level.
- CNVM only works in the `Default` Kibana space. Installing the CNVM integration on a different Kibana space will not work.
- CNVM can only be deployed on ARM-based VMs.
- You need an AWS user account with permissions to perform the following actions: run CloudFormation templates, create IAM Roles and InstanceProfiles, and create EC2 SecurityGroups and Instances.
- Depending on whether you want to `read`, `write`, or `manage` CNVM data, you need [specific privileges](https://www.elastic.co/docs/solutions/security/cloud/cnvm-privilege-requirements).
- CNVM is supported only on AWS. AWS GovCloud is not supported. To request support, [open a GitHub ticket](https://github.com/elastic/kibana/issues/new/choose).


## Set up CNVM for AWS

To set up the CNVM integration for AWS, install the integration on a new Elastic Agent policy, sign into the AWS account you want to scan, and run the [CloudFormation](https://docs.aws.amazon.com/cloudformation/index.html) template.
<important>
  Do not add the integration to an existing Elastic Agent policy. It should always be added to a new policy since it should not run on VMs with existing workloads. For more information, refer to [How CNVM works](/docs/solutions/security/cloud/cloud-native-vulnerability-management#vuln-management-overview-how-it-works).
</important>


### Step 1: Add the CNVM integration

1. Find **Integrations** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Search for and select **Cloud Native Vulnerability Management**.
3. Click **Add Cloud Native Vulnerability Management**.
4. Give your integration a name that matches its purpose or the AWS account region you want to scan for vulnerabilities (for example, `uswest2-aws-account`.)
   ![The CNVM integration setup page](https://www.elastic.co/docs/solutions/images/security-cnvm-setup-1.png)
5. Click **Save and continue**. The integration will create a new Elastic Agent policy.
6. Click **Add Elastic Agent to your hosts**.


### Step 2: Sign in to the AWS management console

1. Open a new browser tab and use it to sign into your AWS management console.
2. Switch to the cloud region with the workloads that you want to scan for vulnerabilities.

<important>
  The integration will only scan VMs in the region you select. To scan multiple regions, repeat this setup process for each region.
</important>


### Step 3: Run the CloudFormation template

1. Switch back to the tab where you have Kibana open.
2. Click **Launch CloudFormation**. The CloudFormation page appears.
   ![The cloud formation template](https://www.elastic.co/docs/solutions/images/security-cnvm-cloudformation.png)
3. Click **Create stack**.  To avoid authentication problems, you can only make configuration changes to the VM InstanceType, which you could make larger to increase scanning speed.
4. Wait for the confirmation that Elastic Agent was enrolled.
5. Your data will start to appear on the **Vulnerabilities** tab of the [Findings page](https://www.elastic.co/docs/solutions/security/cloud/findings-page-3).