﻿---
title: View and manage KSPM misconfigurations in Findings
description: The Misconfigurations tab on the Findings page displays the configuration risks identified by the CSPM and KSPM integrations. KSPM findings indicate whether...
url: https://www.elastic.co/docs/solutions/security/cloud/findings-page-2
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# View and manage KSPM misconfigurations in Findings
The **Misconfigurations** tab on the Findings page displays the configuration risks identified by the [CSPM](https://www.elastic.co/docs/solutions/security/cloud/cloud-security-posture-management) and [KSPM](https://www.elastic.co/docs/solutions/security/cloud/kubernetes-security-posture-management) integrations.
![Findings page](https://www.elastic.co/docs/solutions/images/security-findings-page.png)


## What are KSPM findings?

KSPM findings indicate whether a given resource passed or failed evaluation against a specific security guideline. Each finding includes metadata about the resource evaluated and the security guideline used to evaluate it. Each finding’s result (`pass` or `fail`) indicates whether a particular part of your infrastructure meets a security guideline.

## Group and filter findings

By default, the Findings page lists all findings, without grouping or filtering.

### Group findings

Click **Group findings by** to group your data by a field. Select one of the suggested fields or **Custom field** to choose your own. You can select up to three group fields at once.
- When grouping is turned on, click a group to expand it and examine all sub-groups or findings within that group.
- To turn off grouping, click **Group findings by** and select **None**.
  <note>
  Multiple groupings apply to your data in the order you selected them. For example, if you first select **Cloud account**, then select **Resource**, the top-level grouping will be based on **Cloud account**, and its subordinate grouping will be based on **Resource**.
  </note>


### Filter findings

You can filter findings data in two ways:
- **KQL search bar**: For example, search for `result.evaluation : failed` to view all failed findings.
- **In-table value filters**: Hover over a finding to display available inline actions. Use the Filter In (plus) and Filter Out (minus) buttons.


### Customize the Findings table

You can use the toolbar buttons in the upper-left of the Findings table to select which columns appear:
- **Columns**: Select the left-to-right order in which columns appear.
- **Sort fields**: Sort the table by one or more columns, or turn sorting off.
- **Fields**: Select which fields to display for each finding. Selected fields appear in the table and the **Columns** menu.

<tip>
  You can also click a column’s name to open a menu that allows you to perform multiple actions on the column.
</tip>


## Remediate failed findings

To remediate failed findings and reduce your attack surface:
1. First, [filter for failed findings](/docs/solutions/security/cloud/findings-page#cspm-findings-page-filter-findings).
2. Click the arrow to the left of a failed finding to open the findings flyout.
3. Follow the steps under **Remediation**.
   <note>
   Remediation steps typically include commands for you to execute. These sometimes contain placeholder values that you must replace before execution.
   </note>


## Generate alerts for failed Findings

You can create detection rules that detect specific failed findings directly from the Findings page.
1. Click the arrow to the left of a Finding to open the findings flyout.
2. Click **Take action**, then **Create a detection rule**. This automatically creates a detection rule that creates alerts when the associated benchmark rule generates a failed finding.
3. To review or customize the new rule, click **View rule**.