﻿---
title: Kubernetes dashboard
description: 
url: https://www.elastic.co/docs/solutions/security/cloud/d4c/kubernetes-dashboard
products:
  - Elastic Security
applies_to:
  - Serverless Security projects: Beta
  - Elastic Stack: Beta since 9.3
---

# Kubernetes dashboard
The Kubernetes dashboard provides insight into Linux process data from your Kubernetes clusters. It shows sessions in detail and in the context of your monitored infrastructure.

## Requirements

- Kubernetes node operating systems must have Linux kernels 5.10.16 or higher.
- This feature is currently available on GKE and EKS using Linux hosts and Kubernetes versions that match [these](/docs/solutions/security/cloud/d4c/d4c-overview#_support_matrix) specifications.

![The Kubernetes dashboard](https://www.elastic.co/docs/solutions/images/security-kubernetes-dashboard.png)

The numbered sections are described below:
1. The charts at the top of the dashboard provide an overview of your monitored Kubernetes infrastructure. You can hide them by clicking **Hide charts**.
2. The tree navigation menu allows you to navigate through your deployments and select the scope of the sessions table to the right. You can select any item in the menu to show its sessions. In Logical view, the menu is organized by Cluster, Namespace, Pod, and Container image. In Infrastructure view, it is organized by Cluster, Node, Pod, and Container image.
3. The sessions table displays sessions collected from the selected element of your Kubernetes infrastructure. You can view it in fullscreen by selecting the button in the table’s upper right corner. You can sort the table by any of its fields.

You can filter the data using the KQL search bar and date picker at the top of the page.
From the sessions table’s Actions column, you can take the following investigative actions:
- View details
- [Open in Timeline](https://www.elastic.co/docs/solutions/security/investigate/timeline)
- [Run Osquery](https://www.elastic.co/docs/solutions/security/investigate/run-osquery-from-alerts)
- [Analyze event](https://www.elastic.co/docs/solutions/security/investigate/visual-event-analyzer)
- [Open Session View](https://www.elastic.co/docs/solutions/security/investigate/session-view)

Session View displays Kubernetes metadata under the **Metadata** tab of the Detail panel:
![The Detail panel's metadata tab](https://www.elastic.co/docs/solutions/images/security-d4c-metadata-tab.png)

The **Metadata** tab is organized into these expandable sections:
- **Metadata:** `hostname`, `id`, `ip`, `mac`, `name`, Host OS information
- **Cloud:** `instance.name`, `provider`, `region`, `account.id`, `project.id`
- **Container:** `id`, `name`, `image.name`, `image.tag`, `image.hash.all`
- **Orchestrator:** `resource.ip`, `resource.name`, `resource.type`, `namespace`, `cluster.id`, `cluster.name`, `parent.type`


## Setup

To get data for this dashboard, set up [Cloud Workload Protection for Kubernetes](https://www.elastic.co/docs/solutions/security/cloud/d4c/get-started-with-d4c) for the clusters you want to display on the dashboard.
<important>
  This dashboard uses data from the `logs-*` index pattern, which is included by default in the [`securitySolution:defaultIndex` advanced setting](https://www.elastic.co/docs/solutions/security/get-started/configure-advanced-settings). To collect data from multiple Elasticsearch clusters (as in a cross-cluster deployment), update `logs-*` to `*:logs-*`.
</important>