﻿---
title: Get started with Defend for Containers for Kubernetes
description: This page describes how to set up Defend for Containers (D4C) for Kubernetes. First, you’ll need to deploy Elastic’s Defend for Containers integration...
url: https://www.elastic.co/docs/solutions/security/cloud/d4c/get-started-with-d4c
products:
  - Elastic Security
applies_to:
  - Serverless Security projects: Beta
  - Elastic Stack: Beta since 9.3
---

# Get started with Defend for Containers for Kubernetes
This page describes how to set up Defend for Containers (D4C) for Kubernetes.
<admonition title="Requirements">
  - Kubernetes node operating systems must have Linux kernels 5.10.16 or higher.
  - Elastic Stack version 9.3 or higher.
</admonition>


## Initial setup

First, you’ll need to deploy Elastic’s Defend for Containers integration to the Kubernetes clusters you wish to monitor.
1. Find **Container Workload Security** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Click **Add D4C Integration**.
2. Name the integration. The default name, which you can change, is `cloud_defend-1`.
3. (Optional) Adjust the **Selectors** and **Responses** sections in the [integration’s policy](https://www.elastic.co/docs/solutions/security/cloud/d4c/d4c-policies) to modify the core container workload protection capabilities that the D4C integration policy will implement. You can change these later, if needed.
4. Under **Where to add this integration**, select an existing or new agent policy.
5. Click **Save & Continue**, then **Add Elastic Agent to your hosts**.
6. On the Elastic Agent policy page, click **Add agent** to open the Add agent flyout.
7. In the flyout, go to step 3 (**Install Elastic Agent on your host**) and select the **Kubernetes** tab.
8. Download or copy the manifest (`elastic-agent-managed-kubernetes.yml`).
9. Open the manifest using your favorite editor, and uncomment the `#capabilities` section:
   ```json
   #capabilities:
   #  add:
   #    - BPF # (Since Linux 5.8) allows loading of BPF programs, create most map types, load BTF, iterate programs and maps.
   #    - PERFMON # (Since Linux 5.8) allows attaching of BPF programs used for performance metrics and observability operations.
   #    - SYS_RESOURCE # Allow use of special resources or raising of resource limits. Used by 'Defend for Containers' to modify 'rlimit_memlock'
   #    - SYS_ADMIN # Required if using Defend for Containers on Azure Kubernetes Service (AKS)
   ```
10. From the directory where you saved the manifest, run the command `kubectl apply -f elastic-agent-managed-kubernetes.yml`.
11. Wait for the **Confirm agent enrollment** dialogue to show that data has started flowing from your newly-installed agent, then click **Close**.


## Get started with threat detection

The [default D4C policy](/docs/solutions/security/cloud/d4c/d4c-policies#d4c-default-policies) provides threat detection capabilities. It is designed to send process telemetry events (`fork` and `exec`) to Elasticsearch.
To detect threats using this data, you’ll need active [detection rules](https://www.elastic.co/docs/solutions/security/detect-and-alert). You can use Elastic's prebuilt rules that are designed for this data or create [custom rules](https://www.elastic.co/docs/solutions/security/detect-and-alert/create-detection-rule).
To set up threat detection, install and enable Elastic's prebuilt rules that use data ingested by D4C:
1. Find **Detection rules (SIEM)** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Click **Add Elastic rules**.
2. Click the **Tags** filter next to the search bar, and search for the `Data Source: Elastic Defend for Containers` tag.
3. Select all the displayed rules, then click **Install *x* selected rule(s)**.
4. Return to the **Rules** page. Click the **Tags** filter next to the search bar, and search for the `Data Source: Elastic Defend for Containers` tag.
5. Select all the rules with the tag, and then click **Bulk actions > Enable**.


## Get started with drift detection and prevention

Elastic Security defines container drift as the creation or modification of an executable within a container. Blocking drift restricts the number of attack vectors available to bad actors by prohibiting them from using external tools.
The [default D4C policy](/docs/solutions/security/cloud/d4c/d4c-policies#d4c-default-policies) provides drift detection and prevention capabilities. Before you enable drift detection, do the following:
- Make sure the default D4C policy is active.
- Make sure you've installed and enabled the "Container Workload Protection" prebuilt rule. The steps for installing and enabling prebuilt rules are above.

To enable drift prevention, create a new policy:
1. Find **Container Workload Security** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), then select your integration.
2. Under **Selectors**, click **Add selector > File Selector**. By default, it selects the operations `createExecutable` and `modifyExecutable`.
3. Name the selector, for example: `blockDrift`.
4. Scroll down to the **Responses** section and click **Add response > File Response**.
5. Under **Match selectors**, add the name of your new selector, for example: `blockDrift`.
6. Select the **Alert** and **Block** actions.
7. Click **Save integration**.

<important>
  Before you enable blocking, we strongly recommend you observe a production workload that’s using the default D4C policy to ensure that the workload does not create or modify executables as part of its normal operation.
</important>


## Policy validation

To ensure the stability of your production workloads, you should test policy changes before implementing them in production workloads. We also recommend you test policy changes on a simulated environment with workloads similar to production. This approach allows you to test that policy changes prevent undesirable behavior without disrupting your production workloads.