﻿---
title: CSPM privilege requirements
description: This page lists required privileges for Elastic Security's CSPM features. There are three access levels: read, write, and manage. Each access level and...
url: https://www.elastic.co/docs/solutions/security/cloud/cspm-privilege-requirements
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# CSPM privilege requirements
This page lists required privileges for Elastic Security's CSPM features. There are three access levels: read, write, and manage. Each access level and its requirements are described next on this page.

## Read

Users with these minimum permissions can view data on the **Findings** page and the Cloud Posture dashboard.

### Elasticsearch index privileges

`Read` privileges for the following Elasticsearch indices:
- `logs-cloud_security_posture.findings_latest-*`
- `logs-cloud_security_posture.scores-*`
- <applies-to>Elastic Stack: Generally available since 9.1</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> `security_solution-cloud_security_posture.misconfiguration_latest*`


### Kibana privileges

- `Security: Read`


## Write

Users with these minimum permissions can view data on the **Findings** page and the Cloud Posture dashboard, create detection rules from the findings details flyout, and enable or disable benchmark rules.

### Elasticsearch index privileges

`Read` privileges for the following Elasticsearch indices:
- `logs-cloud_security_posture.findings_latest-*`
- `logs-cloud_security_posture.scores-*`
- <applies-to>Elastic Stack: Generally available since 9.1</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> `security_solution-cloud_security_posture.misconfiguration_latest*`


### Kibana privileges

- `Security: All`


## Manage

Users with these minimum permissions can view data on the **Findings** page and the Cloud Posture dashboard, create detection rules from the findings details flyout, enable or disable benchmark rules, and install, update, or uninstall CSPM integrations and assets.

### Elasticsearch index privileges

`Read` privileges for the following Elasticsearch indices:
- `logs-cloud_security_posture.findings_latest-*`
- `logs-cloud_security_posture.scores-*`
- <applies-to>Elastic Stack: Generally available since 9.1</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> `security_solution-cloud_security_posture.misconfiguration_latest*`


### Kibana privileges

- `Security: All`
- `Spaces: All`
- `Fleet: All`
- `Integrations: All`