﻿---
title: CNVM privilege requirements
description: This page lists required privileges for Elastic Security's CNVM features. There are three access levels: read, write, and manage. Each access level and...
url: https://www.elastic.co/docs/solutions/security/cloud/cnvm-privilege-requirements
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# CNVM privilege requirements
This page lists required privileges for Elastic Security's CNVM features. There are three access levels: `read`, `write`, and `manage`. Each access level and its requirements are described next on this page.

## Read

Users with these minimum permissions can view data on the **Findings** page.

### Elasticsearch index privileges

`Read` privileges for the following Elasticsearch indices:
- `logs-cloud_security_posture.vulnerabilities_latest-default`
- `logs-cloud_security_posture.scores-default`


### Kibana privileges

- `Security: Read`


## Write

Users with these minimum permissions can view data on the **Findings** page and create detection rules from the findings details flyout.

### Elasticsearch index privileges

`Read` privileges for the following Elasticsearch indices:
- `logs-cloud_security_posture.vulnerabilities_latest-default`
- `logs-cloud_security_posture.scores-default`


### Kibana privileges

- `Security: All`


## Manage

Users with these minimum permissions can view data on the **Findings** page, create detection rules from the findings details flyout, and install, update, or uninstall integrations and assets.

### Elasticsearch index privileges

`Read` privileges for the following Elasticsearch indices:
- `logs-cloud_security_posture.vulnerabilities_latest-default`
- `logs-cloud_security_posture.scores-default`


### Kibana privileges

- `Security: All`
- `Spaces: All`
- `Fleet: All`
- `Integrations: All`