﻿---
title: Cloud workload protection for VMs
description: Cloud workload protection helps you monitor and protect your Linux VMs. It uses the Elastic Defend integration to capture cloud workload telemetry containing...
url: https://www.elastic.co/docs/solutions/security/cloud/cloud-workload-protection-for-vms
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Cloud workload protection for VMs
Cloud workload protection helps you monitor and protect your Linux VMs. It uses the [Elastic Defend](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend) integration to capture cloud workload telemetry containing process, file, and network activity.
Use this telemetry with out-of-the-box detection rules and machine learning models to automate processes that identify cloud threats.

## Use cases

- **Runtime monitoring of cloud workloads:** Provides visibility into cloud workloads, context for detected threats, and the historical data needed for retroactive threat investigations.
- **Cloud-native threat detection and prevention:** Provides security coverage for Linux, containers, and serverless applications. Protects against known and unknown threats using on-host detections and protections against malicious behavior, memory threats, and malware.
- **Reducing the time to detect and remediate runtime threats:** Helps you resolve potential threats by showing alerts in context, making the data necessary for further investigations readily available, and providing remediation options.

To continue setting up your cloud workload protection, learn more about:
- [**Getting started with Elastic Defend**](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend): configure Elastic Defend to protect your hosts. Be sure to select one of the "Cloud workloads" presets if you want to collect session data by default, including process, file, and network telemetry.
- [**Session view**](https://www.elastic.co/docs/solutions/security/investigate/session-view): examine Linux process data organized in a tree-like structure according to the Linux logical event model, with processes organized by parentage and time of execution. Use it to monitor and investigate session activity, and to understand user and service behavior on your Linux infrastructure.
- [**Environment variable capture**](https://www.elastic.co/docs/solutions/security/cloud/capture-environment-variables): Capture the environment variables associated with process events, such as `PATH`, `LD_PRELOAD`, or `USER`.