﻿---
title: Cloud native vulnerability management
description: Elastic’s Cloud Native Vulnerability Management (CNVM) feature helps you identify known vulnerabilities in your cloud workloads. Setup uses infrastructure...
url: https://www.elastic.co/docs/solutions/security/cloud/cloud-native-vulnerability-management
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Cloud native vulnerability management
Elastic’s Cloud Native Vulnerability Management (CNVM) feature helps you identify known vulnerabilities in your cloud workloads.
Setup uses infrastructure as code. For instructions, refer to [Get started with Cloud Native Vulnerability Management](https://www.elastic.co/docs/solutions/security/cloud/get-started-with-cnvm).
<note>
  CNVM currently only supports AWS EC2 Linux workloads in AWS commercial cloud. AWS GovCloud is not supported.
</note>

<admonition title="Requirements">
  - Elastic Stack users: Elastic Stack version 8.8 or higher and an [appropriate subscription](https://www.elastic.co/pricing).
  - CNVM only works in the `Default` Kibana space. Installing the CNVM integration on a different Kibana space will not work.
  - CNVM can only be deployed on ARM-based VMs.
  - You need an AWS user account with permissions to perform the following actions: run CloudFormation templates, create IAM Roles and InstanceProfiles, and create EC2 SecurityGroups and Instances.
  - Depending on whether you want to `read`, `write`, or `manage` CNVM data, you need [specific privileges](https://www.elastic.co/docs/solutions/security/cloud/cnvm-privilege-requirements).
</admonition>


## How CNVM works

During setup, you will use an infrastructure as code provisioning template to create a new virtual machine (VM) in the cloud region you wish to scan. This VM installs Elastic Agent and the Cloud Native Vulnerability Management (CNVM) integration, and conducts all vulnerability scanning.
The CNVM integration uses [Trivy](https://github.com/aquasecurity/trivy), a comprehensive open-source security scanner, to scan cloud workloads and identify security vulnerabilities. During each scan, the VM running the integration takes a snapshot of all cloud workloads in its region using the snapshot APIs of the cloud service provider, and analyzes them for vulnerabilities using Trivy. Therefore, scanning does not use resources on the VMs being scanned. All resource usage occurs on the VM installed during CNVM setup.
The scanning process begins immediately upon deployment, then repeats every twenty-four hours. After each scan, the integration sends the discovered vulnerabilities to Elasticsearch, where they appear in the **Vulnerabilities** tab of the [Findings page](https://www.elastic.co/docs/solutions/security/cloud/findings-page-3).
<note>
  Environments with more VMs take longer to scan.
</note>