﻿---
title: AI use cases
description: The guides in this section describe example workflows for AI Assistant and Attack discovery. Refer to them for examples of each tool’s individual capabilities...
url: https://www.elastic.co/docs/solutions/security/ai/use-cases
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# AI use cases
The guides in this section describe example workflows for AI Assistant and Attack discovery. Refer to them for examples of each tool’s individual capabilities and how they can work together.
- [Triage alerts](https://www.elastic.co/docs/solutions/security/ai/triage-alerts)
- [Identify, investigate, and document threats](https://www.elastic.co/docs/solutions/security/ai/identify-investigate-document-threats)
- [Generate, customize, and learn about ES|QL queries](https://www.elastic.co/docs/solutions/security/ai/generate-customize-learn-about-esorql-queries)

For general information, refer to [AI Assistant](https://www.elastic.co/docs/solutions/security/ai/ai-assistant) or [Attack discovery](https://www.elastic.co/docs/solutions/security/ai/attack-discovery).

## Other AI-powered tools

In addition to AI Assistant and Attack Discovery, Elastic Security provides several other AI-powered tools for specific use cases. These include:
- [Automatic Import](https://www.elastic.co/docs/solutions/security/get-started/automatic-import): Helps you quickly parse, ingest, and create [ECS mappings](https://www.elastic.co/elasticsearch/common-schema) for data from sources that don’t yet have prebuilt Elastic integrations. This can accelerate your migration to Elastic Security, and help you quickly add new data sources to an existing SIEM solution in Elastic Security.
- [Automatic Migration](https://www.elastic.co/docs/solutions/security/get-started/automatic-migration): Helps you quickly convert SIEM rules from the Splunk Processing Language (SPL) to the Elasticsearch Query Language (ES|QL). If comparable Elastic-authored rules exist, it simplifies onboarding by mapping your rules to them. Otherwise, it creates custom rules on the fly so you can verify and edit them instead of writing them from scratch.
- [Automatic Troubleshooting](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/automatic-troubleshooting): Helps you quickly check whether your endpoints have third-party AV software installed by analyzing file event logs from your hosts to determine whether antivirus software is present. From there, you can address any incompatibilities to make sure your endpoints are protected.
  <applies-to>Elastic Stack: Generally available since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> Helps you detect any issues in Elastic Defend integration policies and suggests remediation steps.