﻿---
title: Identify, investigate, and document threats
description: Together, Elastic AI Assistant and Attack discovery can help you identify and mitigate threats, investigate incidents, and generate incident reports in...
url: https://www.elastic.co/docs/solutions/security/ai/identify-investigate-document-threats
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Identify, investigate, and document threats
Together, [Elastic AI Assistant](https://www.elastic.co/docs/solutions/security/ai/ai-assistant) and [Attack discovery](https://www.elastic.co/docs/solutions/security/ai/attack-discovery) can help you identify and mitigate threats, investigate incidents, and generate incident reports in various languages so you can monitor and protect your environment.
In this guide, you’ll learn how to:
- [Use Attack discovery to identify threats](#use-case-incident-reporting-use-attack-discovery-to-identify-threats)
- [Use AI Assistant to analyze a threat](#use-case-incident-reporting-use-ai-assistant-to-analyze-a-threat)
- [Create a case using AI Assistant](#use-case-incident-reporting-create-a-case-using-ai-assistant)
- [Translate incident information to a different human language using AI Assistant](#use-case-incident-reporting-translate)


## Use Attack discovery to identify threats

Attack discovery can detect a wide range of threats by finding relationships among alerts that may indicate a coordinated attack. This enables you to comprehend how threats move through and affect your systems. Attack discovery generates a detailed summary of each potential threat and can highlight avenues for further investigation. Learn how to [get started with Attack discovery](https://www.elastic.co/docs/solutions/security/ai/attack-discovery).
<important>
  To ensure that Attack Discovery analyzes related alerts together (and can therefore identify their connections), pay attention to the [alert filtering](https://www.elastic.co/docs/solutions/security/ai/attack-discovery) settings. This allows you to target Attack Discovery at specific groups of alerts, such as those related to a particular host, user, date and time, incident, or customer.
</important>

![An Attack discovery card showing an attack with 11 related alerts](https://www.elastic.co/docs/solutions/images/security-attck-disc-11-alerts-disc.png)

In the example above, Attack discovery found connections between thirteen alerts, and used them to identify and describe an attack chain.
After Attack discovery outlines your threat landscape, use Elastic AI Assistant to quickly analyze a threat in detail.

## Use AI Assistant to analyze a threat

From a discovery on the Attack discovery page, click **View in AI Assistant** or **Add to chat** to start a chat that includes the discovery as context.
![A dialogue with AI Assistant that has the attack discovery as context](https://www.elastic.co/docs/solutions/images/security-attck-disc-remediate-threat.gif)

AI Assistant can quickly compile essential data and provide suggestions to help you generate an incident report and plan an effective response. You can ask it to provide relevant data or answer questions, such as “How can I remediate this threat?” or “What ES|QL query would isolate actions taken by this user?”
![An AI Assistant dialogue in which the user asks for a purpose-built ES|QL query](https://www.elastic.co/docs/solutions/images/security-attck-disc-esql-query-gen-example.png)

The image above shows an ES|QL query generated by AI Assistant in response to a user prompt. Learn more about [using AI Assistant for ES|QL](https://www.elastic.co/docs/solutions/security/ai/generate-customize-learn-about-esorql-queries).
At any point in a conversation with AI Assistant, you can add data, narrative summaries, and other information from its responses to Elastic Security's case management system to generate incident reports.

## Generate reports

From the AI Assistant dialog window, click **Add to case** (![Add to case icon](https://www.elastic.co/docs/solutions/images/security-icon-add-to-case.png "title")) next to a message to add the information in that message to a [case](https://www.elastic.co/docs/solutions/security/investigate/cases). Cases help centralize relevant details in one place for easy sharing with stakeholders.
If you add a message that contains a discovery to a case, AI Assistant automatically adds the attack summary and all associated alerts to the case. You can also add AI Assistant messages that contain remediation steps and relevant data to the case.

## Translate incident information to a different human language using AI Assistant

![An AI Assistant dialogue in which the assistant translates from English to Japanese](https://www.elastic.co/docs/solutions/images/security-attck-disc-translate-japanese.png)

AI Assistant can translate its findings into other human languages, helping to enable collaboration among global security teams, and making it easier to operate within multilingual organizations.
After AI Assistant provides information in one language, you can ask it to translate its responses. For example, if it provides remediation steps for an incident, you can instruct it to “Translate these remediation steps into Japanese.” You can then add the translated output to a case. This can help team members receive the same information and insights regardless of their primary language.
<note>
  In our internal testing, AI Assistant translations preserved the accuracy of the original content. However, all LLMs can make mistakes, so use caution.
</note>