﻿---
title: Generate, customize, and learn about ES|QL queries
description: Elastic AI Assistant can help you learn about and leverage the Elasticsearch Query Language (ES|QL) in many ways, including: Education and training: AI...
url: https://www.elastic.co/docs/solutions/security/ai/generate-customize-learn-about-esorql-queries
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Generate, customize, and learn about ES|QL queries
Elastic AI Assistant can help you learn about and leverage the Elasticsearch Query Language (ES|QL) in many ways, including:
- **Education and training**: AI Assistant can serve as a powerful ES|QL learning tool. Ask it for examples, explanations of complex queries, and best practices.
- **Writing new queries**: Prompt AI Assistant to provide a query that accomplishes a particular task, and it will generate a query matching your description. For example: "Write a query to identify documents with `curl.exe` usage and calculate the sum of `destination.bytes`" or "What query would return all user logins to [a host] in the last six hours?"
- **Providing feedback to optimize existing queries**: Send AI Assistant a query you want to work on and ask it for improvements, refactoring, a general assessment, or to optimize the query’s performance with large data sets.
- **Customizing queries for your environment**: Since each environment is unique, you may need to customize queries that you used in other contexts. AI Assistant can suggest necessary modifications based on contextual information you provide.
- **Troubleshooting**: Having trouble with a query or getting unexpected results? Ask AI Assistant to help you troubleshoot.

In these ways and others, AI Assistant can enable you to make use of ES|QL's advanced search capabilities to accomplish goals across Elastic Security.