﻿---
title: Upgrade from Elastic AI SOC Engine to Elastic Security to access additional features
description: This page describes how to upgrade an Elastic Security Serverless project from the Elastic AI SOC Engine (EASE) feature tier to the Security Analytics...
url: https://www.elastic.co/docs/solutions/security/ai/ease/ease-upgrade
applies_to:
  - Serverless Security projects: Preview
---

# Upgrade from Elastic AI SOC Engine to Elastic Security to access additional features
This page describes how to upgrade an Elastic Security Serverless project from the Elastic AI SOC Engine (EASE) feature tier to the Security Analytics Essentials or Security Analytics Complete feature tiers.

## Why upgrade?

EASE provides a small subset of the features available on other Elastic Security Serverless feature tiers. It's designed to add a layer of AI features onto your existing SOC software stack. In contrast, Elastic Security provides a full set of SOC capabilities including many additional ways to ingest data, prebuilt and customizable detection rules, response actions, integrated threat intelligence, runtime protection, data visualization, and more.
For a full breakdown of the features available in the Security Analytics Essentials and Security Analytics Complete feature tiers, refer to [Elastic Security Serverless pricing](https://www.elastic.co/pricing/serverless-security).
<important>
  The AI features present in EASE are not available on the Essentials tier.
</important>


## How to upgrade from EASE to other feature tiers

1. Log in to the [Elastic Cloud console](https://console.qa.cld.elstc.co/).
2. Find the project you wish to upgrade on the list of serverless projects, and click **Manage**.
   ![The cloud console showing an EASE project with the MANAGE button highlighted](https://www.elastic.co/docs/solutions/images/security-ease-cloud-console-manage-project.png)
3. On the project management page, next to **Project features**, click **Edit**.
   ![The manage project page for an EASE project with the EDIT button highlighted](https://www.elastic.co/docs/solutions/images/security-ease-cloud-console-edit-project-features.png)
4. Select either the **Security Analytics Essentials** or **Security Analytics Complete** options, and select any desired add-on options. Click **Save**.

You can return to this page at any point to switch between Essentials and Complete and change your add-on selections.
However, once you upgrade from EASE to another product tier, you cannot revert or downgrade the project back to EASE. You can always create another new project of any tier.

## What to do after upgrading an EASE project

When you upgrade an EASE project, you gain access to all the Elastic Security capabilities included in your selected [feature tier](https://www.elastic.co/pricing/serverless-security). To learn more about what Elastic Security can do and how to use it, refer to [Get started with Elastic Security](https://www.elastic.co/docs/solutions/security/get-started).