﻿---
title: Elastic AI SOC Engine with Elastic Security Serverless
description: Elastic AI SOC Engine (EASE) is an Elastic Security Serverless project type that provides cutting-edge AI-powered tools to augment your existing SIEM...
url: https://www.elastic.co/docs/solutions/security/ai/ease/ease-intro
applies_to:
  - Serverless Security projects: Preview
---

# Elastic AI SOC Engine with Elastic Security Serverless
Elastic AI SOC Engine (EASE) is an Elastic Security Serverless project type that provides cutting-edge AI-powered tools to augment your existing SIEM and EDR/XDR platforms. Because serverless deployments are quick to deploy and easy to configure, and because all the integrations that you can use to ingest data to EASE support fast and easy [agentless](https://www.elastic.co/docs/solutions/security/get-started/agentless-integrations) deployment, you can start getting value from EASE in minutes.
This page describes how to create an EASE project, how to ingest your data, and how to use its key features.

## Features

EASE provides a set of capabilities designed to help make the most of each security analyst’s time, fight alert fatigue, and reduce your mean time to respond. Once your data is ingested, you can start using the following features:
- **[Attack Discovery](https://www.elastic.co/docs/solutions/security/ai/attack-discovery)**: Helps you analyze alerts in your environment and identify threats. Each discovery represents a potential attack and describes relationships among multiple alerts to tell you which users and hosts are involved, how alerts correspond to the MITRE ATT&CK matrix, and which threat actor might be responsible.
  ![Attack Discovery detail view](https://www.elastic.co/docs/solutions/images/security-attck-disc-example-disc.png)
  You can [schedule](/docs/solutions/security/ai/attack-discovery#schedule-discoveries) Attack Discovery to run automatically, and notify you of any discoveries through a range of connectors such as Slack, Teams, PagerDuty, or email.
- **[AI Assistant](https://www.elastic.co/docs/solutions/security/ai/ai-assistant)**: An LLM-powered virtual assistant specialized for digital security; it helps with data analysis, alert investigation, incident response, and ES|QL query generation. You can add custom background knowledge and data to its [knowledge base](https://www.elastic.co/docs/solutions/security/ai/ai-assistant-knowledge-base) and use natural language to ask for its assistance with your SOC operations.
  ![A new conversation with AI Assistant](https://www.elastic.co/docs/solutions/images/security-ease-ai-assistant.png)
  You can add custom information to AI Assistant's [Knowledge Base](https://www.elastic.co/docs/solutions/security/ai/ai-assistant-knowledge-base), either in the form of individual documents or entire indices containing numerous documents. This information informs the AI Assistant's responses and can include everything from threat intelligence, to information about your team's on-call rotation, to information about your infrastructure, and more.
- **[Cases](https://www.elastic.co/docs/solutions/security/investigate/cases)**: Helps you track and share related information about security issues. Track key investigation details and collect alerts in a central location.
  ![The Cases page in an EASE project showing the default state](https://www.elastic.co/docs/solutions/images/security-ease-cases.png)
- **[Value report](https://www.elastic.co/docs/solutions/security/ai/ease/ease-value-report)**:
  The **Value report** page estimates your savings from using Elastic's AI SOC features for alert triage, in terms of **Analyst time saved** and **Cost Savings**. The message at the top of the page explains how those numbers were determined, and how many alerts were **Escalated** and **Filtered** by AI.
  You can interact with the page in the following ways:
  - **Update the time range:** Use the time selector in the upper right corner to select the time range for which to show value metrics.
  - **Export report:** Select **Export report** in the upper right corner to download a sharable PDF of the value report.

  ![The Value Report in an EASE project](https://www.elastic.co/docs/solutions/images/security-ease-value-report.png)


## Create an EASE project

To create an EASE project:
1. [Create](/docs/solutions/security/get-started#create-sec-serverless-project) an Elastic Security Serverless project, and on the **Confirm your project settings** page, select **Elastic AI SOC Engine**.
   ![The Confirm your project settings page](https://www.elastic.co/docs/solutions/images/security-ease-create-ease-project.png)
2. Click **Create serverless project**, and wait for your project to be provisioned. When it's ready, open it.


## Ingest your SIEM and EDR/XDR data

To ingest third-party security data:
1. Go to the **Configurations** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
   ![The integrations page of an EASE project](https://www.elastic.co/docs/solutions/images/security-ease-integrations.png)
2. From the **Integrations** tab, select a SIEM and EDR/XDR platform from which you want to ingest data to view setup instructions and more information. You can ingest data from:
   - CrowdStrike
- Elastic Security
- Google SecOps
- Microsoft Sentinel
- SentinelOne
- Splunk


## Select a model

EASE uses LLM connectors to enable its AI features such as Attack Discovery and AI Assistant. Elastic Managed LLMs are enabled by default. You can also [configure your own third-party LLM connector](https://www.elastic.co/docs/explore-analyze/ai-features/llm-guides/llm-connectors). Keep in mind that different models [perform differently](https://www.elastic.co/docs/solutions/security/ai/large-language-model-performance-matrix) on different tasks.