﻿---
title: View entity details
description: You can learn more about an entity (host, user, or service) from the entity details flyout, which is available throughout the Elastic Security app. To...
url: https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/view-entity-details
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# View entity details
You can learn more about an entity (host, user, or service) from the entity details flyout, which is available throughout the Elastic Security app. To access this flyout, click on an entity name in places such as:
- The Alerts table
- The Entity Analytics overview
- The **Users** and user details pages
- The **Hosts** and host details pages


## Entity details flyout

The entity details flyout includes the following sections:
- <applies-to>Elastic Cloud Serverless: Generally available</applies-to> <applies-to>Elastic Stack: Generally available since 9.3</applies-to> [Entity summary](#entity-summary), which allows you to generate an AI summary of the entity.
- [Entity risk summary](#entity-risk-summary), which displays entity risk data and inputs.
- [Asset Criticality](#asset-criticality), which allows you to view and assign asset criticality.
- [Insights](#insights), which displays vulnerabilities or misconfiguration findings for the entity.
- [Observed data](#observed-data), which displays entity details.

![Host details flyout](https://www.elastic.co/docs/solutions/images/security-host-details-flyout.png)


### Entity summary

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
</applies-to>

<note>
  - To generate an AI summary, you need to configure a [generative AI connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/gen-ai-connectors).
  - This feature is only available for users and hosts.
</note>

The **Entity summary** section allows you to generate an AI-powered summary of the entity's security context. Click **Generate** to create a comprehensive overview that aggregates information from:
- Risk scores and risk inputs
- Asset criticality levels
- Vulnerabilities
- Machine learning anomalies associated with the entity

The summary provides a consolidated view of the entity's security posture, helping you quickly assess its significance and prioritize investigations. It includes information such as:
- The entity's current risk score with details about which alerts or rules contribute most significantly to the score
- The entity's asset criticality level and how it contributes to the overall risk score
- Details about detected vulnerabilities, including CVE identifiers, CVSS scores, affected packages or systems, and remediation guidance
- Recommended next steps based on the entity's security posture, such as updating vulnerable packages, investigating specific alerts, or implementing additional security controls

<tip>
  If you have [AI Assistant](https://www.elastic.co/docs/solutions/security/ai/ai-assistant) or [Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/elastic-agent-builder) set up, you can select **More actions** (`boxes_vertical`) → **Ask AI Assistant** or **Add to chat** to continue the conversation about the entity in AI Assistant or Agent Builder.
</tip>

![Entity summary](https://www.elastic.co/docs/solutions/images/security-entity-summary.png)


### Entity risk summary

<admonition title="Requirements">
  The entity risk summary section is only available if the [risk scoring engine is turned on](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/turn-on-risk-scoring-engine).
</admonition>

The entity risk summary section contains a risk summary visualization and table.
The risk summary visualization shows the entity risk score and risk level. Hover over the visualization to display the **Options** menu. Use this menu to inspect the visualization's queries, add it to a new or existing case, save it to your Visualize Library, or open it in Lens for customization.
The risk summary table shows the category, score, and number of risk inputs that determine the entity risk score. Hover over the table to display the **Inspect** button, which allows you to inspect the table's queries.
To expand the entity risk summary section, click **View risk contributions**. The left panel displays additional details about the entity's risk inputs:
- The asset criticality level and contribution score from the latest risk scoring calculation.
- The top 10 alerts that contributed to the latest risk scoring calculation, and each alert's contribution score.

If more than 10 alerts contributed to the risk scoring calculation, the remaining alerts' aggregate contribution score is displayed below the **Alerts** table.
<applies-to>Elastic Stack: Generally available since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> If you have [AI Assistant](https://www.elastic.co/docs/solutions/security/ai/ai-assistant) set up, you can also ask it to explain how the risk inputs contributed to the entity's risk score and recommend next steps.
![Host risk inputs](https://www.elastic.co/docs/solutions/images/security-host-risk-inputs.png)


### Asset Criticality

The **Asset Criticality** section displays the selected entity's [asset criticality level](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/asset-criticality). Asset criticality contributes to the overall [entity risk score](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/entity-risk-scoring). The criticality level defines how impactful the entity is when calculating the risk score.
![Asset criticality](https://www.elastic.co/docs/solutions/images/security-host-asset-criticality.png)

Click **Assign** to assign a criticality level to the selected entity, or **Change** to change the currently assigned criticality level.

### Insights

The **Insights** section displays [Vulnerabilities Findings](https://www.elastic.co/docs/solutions/security/cloud/findings-page-3) for the host or [Misconfiguration Findings](https://www.elastic.co/docs/solutions/security/cloud/findings-page) for the user. Click **Vulnerabilities** or **Misconfigurations** to expand the flyout and view this data.
![Host details flyout with the Vulnerabilities section expanded](https://www.elastic.co/docs/solutions/images/security--host-details-insights-expanded.png)


### Observed data

This section displays details such as the entity ID, when the entity was first and last seen, and the associated IP addresses and operating system.
![Host observed data](https://www.elastic.co/docs/solutions/images/security-host-observed-data.png)