﻿---
title: View and analyze risk score data
description: The Elastic Security app provides several ways to monitor the change in the risk posture of entities in your environment. In the Entity Analytics overview,...
url: https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/view-analyze-risk-score-data
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# View and analyze risk score data
The Elastic Security app provides several ways to monitor the change in the risk posture of entities in your environment.
<tip>
  After reviewing an entity’s risk score, the recommended next step is to investigate the risky entity in [Timeline](https://www.elastic.co/docs/solutions/security/investigate/timeline).
</tip>


## Entity Analytics overview

In the Entity Analytics overview, you can view entity key performance indicators (KPIs), risk scores, and levels. You can also click the number link in the **Alerts** column to investigate and analyze the alerts on the Alerts page.
If you have enabled the [entity store](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/entity-store), you'll also get access to the **Entities** section, where you can view all hosts, users, and services along with their risk and asset criticality data.
Access the Entity Analytics overview from the following pages:
- <applies-to>Elastic Stack: Generally available since 9.1</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> [Entity analytics](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/overview)
- [Entity analytics dashboard](https://www.elastic.co/docs/solutions/security/dashboards/entity-analytics-dashboard)


## Alert triaging

You can prioritize alert triaging to analyze alerts associated with risky or business-critical entities using the following features in the Elastic Security app.

### Alerts page

Use the Alerts table to investigate and analyze:
- Host, user, and service risk levels
- Host, user, and service risk scores
- Asset criticality

To display entity risk score and asset criticality data in the Alerts table, select **Fields**, and add the following:
- `user.risk.calculated_level`, `host.risk.calculated_level`, or `service.risk.calculated_level`
- `user.risk.calculated_score_norm`, `host.risk.calculated_score_norm`, or `service.risk.calculated_score_norm`
- `user.asset.criticality`, `host.asset.criticality`, or `service.asset.criticality`

Learn more about [customizing the Alerts table](/docs/solutions/security/detect-and-alert/manage-detection-alerts#customize-the-alerts-table).
![Risk scores in the Alerts table](https://www.elastic.co/docs/solutions/images/security-alerts-table-rs.png)


#### Triage alerts associated with high-risk or business-critical entities

To analyze alerts associated with high-risk or business-critical entities, you can filter or group them by entity risk level or asset criticality level.
<note>
  Entity risk fields on alert documents denote the risk at the time the alert was generated, not necessarily the current risk. Additionally, if you change the entity's criticality level after an alert is generated, that alert document will include the original criticality level and will not reflect the new criticality level.
</note>

- Use the drop-down filter controls to filter alerts by entity risk level or asset criticality level. To do this, [edit the default controls](/docs/solutions/security/detect-and-alert/manage-detection-alerts#drop-down-filter-controls) to filter by:
  - `user.risk.calculated_level`, `host.risk.calculated_level`, or `service.risk.calculated_level` for entity risk level:
  ![Alerts filtered by high host risk level](https://www.elastic.co/docs/solutions/images/security-filter-by-host-risk-level.png)
- `user.asset.criticality`, `host.asset.criticality`, or `service.asset.criticality` for asset criticality level:
  ![Filter alerts by asset criticality level](https://www.elastic.co/docs/solutions/images/security-filter-by-asset-criticality.png)
- To group alerts by entity risk level or asset criticality level, select **Group alerts by**, then select **Custom field** and search for:
  - `host.risk.calculated_level`, `user.risk.calculated_level`, or `service.risk.calculated_level` for entity risk level:
  ![Alerts grouped by host risk levels](https://www.elastic.co/docs/solutions/images/security-group-by-host-risk-level.png)
- `host.asset.criticality`, `user.asset.criticality`, or `service.asset.criticality` for asset criticality level:
  ![Alerts grouped by entity asset criticality levels](https://www.elastic.co/docs/solutions/images/security-group-by-asset-criticality.png)
- You can further sort the grouped alerts by highest entity risk score:
  1. Expand a risk level group (for example, **High**) or an asset criticality group (for example, **high_impact**).
2. Select **Sort fields** → **Pick fields to sort by**.
3. Select fields in the following order:
   1. `host.risk.calculated_score_norm`, `user.risk.calculated_score_norm` or `service.risk.calculated_score_norm`: **High-Low**
2. `Risk score`: **High-Low**
3. `@timestamp`: **New-Old**
  ![High-risk alerts sorted by host risk score](https://www.elastic.co/docs/solutions/images/security-hrl-sort-by-host-risk-score.png)


### Alert details flyout

To access risk score data in the alert details flyout, select **Insights** → **Entities** on the **Overview** tab:
![Risk scores in the Alerts flyout](https://www.elastic.co/docs/solutions/images/security-alerts-flyout-rs.png)


### Hosts and Users pages

On the Hosts and Users pages, you can access the risk score data:
- In the **Host risk level** or **User risk level** column on the **All hosts** or **All users** tab:
  ![Host risk level data on the All hosts tab of the Hosts page](https://www.elastic.co/docs/solutions/images/security-hosts-hr-level.png)
- On the **Host risk** or **User risk** tab:
  ![Host risk data on the Host risk tab of the Hosts page](https://www.elastic.co/docs/solutions/images/security-hosts-hr-data.png)


### Host and user details pages

On the host details and user details pages, you can access the risk score data:
- In the Overview section:
  ![Host risk data in the Overview section of the host details page](https://www.elastic.co/docs/solutions/images/security-host-details-overview.png)
- On the **Host risk** or **User risk** tab:
  ![Host risk data on the Host risk tab of the host details page](https://www.elastic.co/docs/solutions/images/security-host-details-hr-tab.png)


### Entity details flyouts

In the entity details flyouts, you can access the risk score data in the risk summary section:
![Host risk data in the Host risk summary section](https://www.elastic.co/docs/solutions/images/security-risk-summary.png)


## Analyze entities over time

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
</applies-to>

The [entity store](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/entity-store) allows you to analyze how entity attributes change over time, making it easier to investigate past activity, track trends, and identify unusual behavior or changes that may indicate risk. Use time-based queries in [Discover](https://www.elastic.co/docs/explore-analyze/discover) to answer questions such as:
- What did user A’s attributes look like on March 15?
- How has user B's risk score changed over the last 90 days?
- Which user had the biggest jump in their risk score since yesterday?

By analyzing current and past entity data, you can understand how your environment and its entities evolve over time.
<note>
  If you enabled the entity store before upgrading to 9.2, you'll need to re-start it using the **On**/**Off** toggle to access the historical analysis feature.
</note>