﻿---
title: Privileged user monitoring requirements
description: This page covers the requirements for using the privileged user monitoring feature, as well as its known limitations. The privileged user monitoring feature...
url: https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/privileged-user-monitoring-requirements
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.3, Preview from 9.1 to 9.2
---

# Privileged user monitoring requirements
This page covers the requirements for using the privileged user monitoring feature, as well as its known limitations.
The privileged user monitoring feature requires:
- <applies-to>Elastic Stack: Generally available</applies-to> The appropriate [subscription](https://www.elastic.co/subscriptions)
- <applies-to>Elastic Cloud Serverless: Generally available</applies-to> The appropriate [feature tier](https://www.elastic.co/pricing/serverless-security)

<applies-to>Elastic Cloud Serverless: Removed</applies-to> <applies-to>Elastic Stack: Removed in 9.3</applies-to> To enable this feature, turn on the `securitySolution:enablePrivilegedUserMonitoring` [advanced setting](/docs/solutions/security/get-started/configure-advanced-settings#access-privileged-user-monitoring).
To use this feature, you need:
- <applies-to>Elastic Stack: Generally available</applies-to> A role with the appropriate [privileges](#privmon_privs)
- <applies-to>Elastic Cloud Serverless: Generally available</applies-to> Either the appropriate [predefined Security user role](#privmon_roles) or a [custom role](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles) with the right [privileges](#privmon_privs)


## Privileges


| Action                                        | Index Privileges                                                                                                                                                                                              | Kibana Privileges                     |
|-----------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------|
| Enable the privileged user monitoring feature | N/A                                                                                                                                                                                                           | **All** for the **Security** feature  |
| View the Privileged user monitoring dashboard | `Read` for the following indices: - `.entity_analytics.monitoring.users-<space-id>` - `risk-score.risk-score-*` - `.alerts-security.alerts-<space-id>` -  `.ml-anomalies-shared` - Security data view indices | **Read** for the **Security** feature |


## Predefined roles

<applies-to>
  - Elastic Cloud Serverless: Generally available
</applies-to>


| Action                                        | Predefined role                                                                                                        |
|-----------------------------------------------|------------------------------------------------------------------------------------------------------------------------|
| Enable privileged user monitoring             | - Platform engineer- Admin                                                                                             |
| View the Privileged user monitoring dashboard | - Tier 1 analyst- Tier 2 analyst- Tier 3 analyst- Rule author- SOC manager- Platform engineer- Detections admin- Admin |


## Known limitations

- Currently, none of the privileged user monitoring visualizations support [cross-cluster search](https://www.elastic.co/docs/explore-analyze/cross-cluster-search) as part of the data that they query from.
- You can define up to 10,000 privileged users per data source.