﻿---
title: Machine learning job and rule requirements
description: To run and create machine learning jobs and rules in serverless, you need the appropriate user role. In Elastic Stack, you need all of these: The appropriate...
url: https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/machine-learning-job-rule-requirements
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Machine learning job and rule requirements
To run and create machine learning jobs and rules in serverless, you need the appropriate [user role](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles). In Elastic Stack, you need all of these:
- The [appropriate license](https://www.elastic.co/subscriptions)
- There must be at least one machine learning node in your cluster
- The `machine_learning_admin` user role

Additionally, to configure [alert suppression](https://www.elastic.co/docs/solutions/security/detect-and-alert/suppress-detection-alerts) for machine learning rules, your role needs the following [index privilege](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-role-management#adding_index_privileges):
- `read` permission for the `.ml-anomalies-*` index

For more information, go to [Set up machine learning features](https://www.elastic.co/docs/explore-analyze/machine-learning/setting-up-machine-learning).
<important>
  Some roles (for example, in Elastic Stack, the `machine_learning_admin` and `machine_learning_user` built-in roles) give access to the results of *all* anomaly detection jobs, irrespective of whether the user has access to the source indices. Likewise, a user who has full or read-only access to machine learning features within a given Kibana space can view the results of *all* anomaly detection jobs that are visible in that space. You must carefully consider who is given these roles and feature privileges; anomaly detection job results may propagate field values that contain sensitive information from the source indices to the results.
</important>