﻿---
title: Entity risk scoring
description: Entity risk scoring is an advanced Elastic Security analytics feature that helps security analysts detect changes in an entity’s risk posture, hunt for...
url: https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/entity-risk-scoring
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Entity risk scoring
Entity risk scoring is an advanced Elastic Security analytics feature that helps security analysts detect changes in an entity’s risk posture, hunt for new threats, and prioritize incident response.
Entity risk scoring allows you to monitor risk score changes of hosts, users, and services in your environment. When generating advanced scoring analytics, the risk scoring engine utilizes threats from its end-to-end XDR use cases, such as SIEM, cloud, and endpoint. It leverages the Elastic SIEM detection engine to generate host, user, and service risk scores from the last 30 days.
It also generates risk scores on a recurring interval, and allows for easy onboarding and management. The engine is built to factor in risks from all Elastic Security use cases, and allows you to customize and control how and when risk is calculated.

## Risk scoring inputs

Entity risk scores are determined by the following risk inputs:

| Risk input                                                                                                                                                                                                                                                                 | Storage location                                              |
|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------|
| [Alerts](https://www.elastic.co/docs/solutions/security/detect-and-alert/manage-detection-alerts)                                                                                                                                                                          | `.alerts-security.alerts-<space-id>` index alias              |
| [Asset criticality level](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/asset-criticality)                                                                                                                                                      | `.asset-criticality.asset-criticality-<space-id>` index alias |
| [Privileged user status](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/privileged-user-monitoring) <applies-to>Elastic Stack: Generally available since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> | `.entity_analytics.monitoring.users-<space-id>` index alias   |

The resulting entity risk scores are stored in the `risk-score.risk-score-<space-id>` data stream alias, and the latest score for each entity is stored in `risk-score.risk-score-latest-<space-id>`.
<note>
  Entities without any alerts, or with only `Closed` alerts, are not assigned a risk score.
</note>


## How are risk scores calculated?

1. The risk scoring engine runs hourly to aggregate `Open` and `Acknowledged` alerts from the last 30 days, including [building block alerts](https://www.elastic.co/docs/solutions/security/detect-and-alert/about-building-block-rules). For each entity, the engine processes up to 10,000 alerts.
   <note>
   When [turning on the risk engine](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/turn-on-risk-scoring-engine), you can choose to also include `Closed` alerts in risk scoring calculations.
   </note>
2. The engine groups alerts by `host.name`, `user.name`, or `service.name`, and aggregates the individual alert risk scores (`kibana.alert.risk_score`) such that alerts with higher risk scores contribute more than alerts with lower risk scores. The resulting aggregated risk score is assigned to the **Alerts** category in the entity's [risk summary](/docs/solutions/security/advanced-entity-analytics/view-entity-details#entity-risk-summary).
3. The engine then updates the score based on the folliowing risk inputs:
   - **[Asset criticality](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/asset-criticality)**: If there is no asset criticality assigned, the entity risk score remains equal to the aggregated score from the **Alerts** category. If a criticality level is assigned, the engine calculates the risk score based on the default risk weight for each criticality level. This risk input is assigned to the **Asset Criticality** category in the entity’s risk summary.
  | Asset criticality level | Default risk weight |
  |-------------------------|---------------------|
  | Low impact              | 0.5                 |
  | Medium impact           | 1                   |
  | High impact             | 1.5                 |
  | Extreme impact          | 2                   |
  <note>
  Asset criticality levels and default risk weights are subject to change.
  </note>
- <applies-to>Elastic Stack: Generally available since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> **[Privileged user status](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/privileged-user-monitoring)**: If a user has privileged user status, it increases the risk score based on the default risk weight. This risk input is assigned to the **Privileged User** category in the entity's risk summary.
  | Privileged user status | Default risk weight |
  |------------------------|---------------------|
  | Yes                    | 2                   |
4. Based on all risk inputs, the risk scoring engine generates a single entity risk score of 0-100. It assigns a risk level by mapping the risk score to one of these levels:
   | Risk level | Risk score |
   |------------|------------|
   | Unknown    | < 20       |
   | Low        | 20-40      |
   | Moderate   | 40-70      |
   | High       | 70-90      |
   | Critical   | > 90       |

The risk score is updated every hour based on the configured date and time range, which defaults to 30 days. Each update generates a new score, calculated independently of any previous scores.

### Residual risk score

In some cases, entities can retain a residual risk score:
- If all alerts for an entity are closed
- If all of the entity’s open alerts fall outside of the configured date and time range

<applies-to>Elastic Stack: Generally available since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to> By default, in these scenarios, entity risk scores are reset to zero if there are no new inputs. If, instead, you want entities to retain their last calculated risk score, select the **Retain last calculated risk scores** checkbox on the [Entity risk score page](/docs/solutions/security/advanced-entity-analytics/turn-on-risk-scoring-engine#_turn_on_the_latest_risk_engine).
<note>
  In versions 9.1 and earlier, residual risk scores are retained by default. This means that each entity keeps its last computed risk score until a new alert triggers a recalculation.
</note>

<dropdown title="Click for a risk score calculation example">
  This example shows how the risk scoring engine calculates the user risk score for `User_A`, whose asset criticality level is **Extreme impact**.There are 5 open alerts associated with `User_A`:
  - Alert 1 with alert risk score 21
  - Alert 2 with alert risk score 45
  - Alert 3 with alert risk score 21
  - Alert 4 with alert risk score 70
  - Alert 5 with alert risk score 21
  To calculate the user risk score, the risk scoring engine:
  1. Sorts the associated alerts in descending order of alert risk score:
     - Alert 4 with alert risk score 70
  - Alert 2 with alert risk score 45
  - Alert 1 with alert risk score 21
  - Alert 3 with alert risk score 21
  - Alert 5 with alert risk score 21
  2. Generates an aggregated risk score of 36.16, and assigns it to `User_A`'s **Alerts** risk category.
  3. Looks up `User_A`'s asset criticality level, and identifies it as **Extreme impact**.
  4. Generates a new risk input under the **Asset Criticality** risk category, with a risk contribution score of 16.95.
  5. Adds the asset criticality risk contribution score (16.95) to the aggregated risk score (36.16), and generates a user risk score of 53.11.
  6. Assigns `User_A` a **Moderate** user risk level.
  If `User_A` had no asset criticality level assigned, the user risk score would remain unchanged at 36.16.
</dropdown>

Learn how to [turn on the risk scoring engine](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/turn-on-risk-scoring-engine).