﻿---
title: Entity risk scoring requirements
description: This page covers the requirements and guidelines for using the entity risk scoring, asset criticality, and entity store features, as well as their known...
url: https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/entity-risk-scoring-requirements
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Entity risk scoring requirements
This page covers the requirements and guidelines for using the entity risk scoring, asset criticality, and entity store features, as well as their known limitations.
To use these features in Elastic Stack, your role must have certain cluster, index, and Kibana privileges. In Serverless, you need the appropriate user roles or a custom role with the right privileges.
In Elastic Stack, these features require a [Platinum subscription](https://www.elastic.co/pricing) or higher. In Serverless, they require the Security Analytics Complete [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).

## Entity risk scoring

To install or run the risk scoring engine, you need the following:
- In Elastic Stack, you need the appropriate [privileges](#_privileges).
- In Serverless, you need either the appropriate [predefined Security user role](#ers_roles) or a [custom role](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles) with the right [privileges](#_privileges).


### Privileges


| Action                  | Cluster Privileges                                                    | Index Privileges                    | Kibana Privileges                     |
|-------------------------|-----------------------------------------------------------------------|-------------------------------------|---------------------------------------|
| Install the risk engine | `manage_index_templates` `manage_transform` `manage_ingest_pipelines` | `All` for `risk-score.risk-score-*` | **Read** for the **Security** feature |
| Run the risk engine     | `manage_transform`                                                    | N/A                                 | **Read** for the **Security** feature |


### Predefined roles

<applies-to>
  - Elastic Cloud Serverless: Generally available
</applies-to>


| Action                  | Predefined role                              |
|-------------------------|----------------------------------------------|
| Install the risk engine | - Platform engineer- Admin                   |
| Run the risk engine     | - Platform engineer- Detections admin- Admin |


### Elasticsearch resource guidelines

<applies-to>
  - Elastic Stack: Generally available
</applies-to>

Follow these guidelines to ensure clusters have adequate memory to handle data volume:
- With 2GB of Java Virtual Machine (JVM) heap memory, the risk scoring engine can safely process around 44 million documents, or 30 days of risk data with an ingest rate of 1000 documents per minute.
- With 1GB of JVM heap, the risk scoring engine can safely process around 20 million documents, or 30 days of risk data with an ingest rate of around 450 documents per minute.


### Known limitations

- The risk scoring engine uses an internal user role to score all hosts, users, and services, and doesn’t respect privileges applied to custom users or roles. After you turn on the risk scoring engine for a Kibana space, all alerts in the space will contribute to host, user, and service risk scores.
- You cannot customize alert data views or risk weights associated with alerts and asset criticality levels.


## Asset criticality

To use asset criticality, you need the following:
- In Elastic Stack, you need the appropriate [privileges](#_privileges_2) for the `.asset-criticality.asset-criticality-<space-id>` index.
- In Serverless, you need either the appropriate [predefined Security user role](#ac_roles) or a [custom role](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles) with the right [privileges](#_privileges_2) for the `.asset-criticality.asset-criticality-<space-id>` index.


### Privileges


| Action                                    | Index privilege    |
|-------------------------------------------|--------------------|
| View asset criticality                    | `read`             |
| View, assign, or change asset criticality | `read` and `write` |
| Unassign asset criticality                | `delete`           |


### Predefined roles

<applies-to>
  - Elastic Cloud Serverless: Generally available
</applies-to>


| Action                                              | Predefined role                                                                                                                                                                            |
|-----------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| View asset criticality                              | - Viewer- Tier 1 analyst                                                                                                                                                                   |
| View, assign, change, or unassign asset criticality | - Editor- Tier 2 analyst- Tier 3 analyst- Threat intelligence analyst- Rule author- SOC manager- Endpoint operations analyst- Platform engineer- Detections admin- Endpoint policy manager |


## Entity store

To turn on the entity store, you need the following:
- In Elastic Stack, you need the appropriate [privileges](#_privileges_3).
- In serverless, you need either the Admin role or a [custom role](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles) with the right [privileges](#_privileges_3).


### Privileges


#### Cluster

- `manage_enrich`
- `manage_index_templates`
- `manage_ingest_pipelines`
- `manage_transform`


#### Index

- `read` and `view_index_metadata` for `.asset-criticality.asset-criticality-*`
- `read` and `manage` for `risk-score.risk-score-*`
- `read` and `manage` for `.entities.v1.latest.*`
- `read` and `view_index_metadata` for all Elastic Security indices


#### Kibana

**All** for the **Security** and **Saved Objects Management** features