﻿---
title: Behavioral detection use cases
description: Behavioral detection identifies potential internal and external threats based on user and host activity. It uses a threat-centric approach to flag suspicious...
url: https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/behavioral-detection-use-cases
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Behavioral detection use cases
Behavioral detection identifies potential internal and external threats based on user and host activity. It uses a threat-centric approach to flag suspicious activity by analyzing patterns, anomalies, and context enrichment.
The behavioral detection feature is built on Elastic Security's foundational SIEM detection capabilities, leveraging machine learning algorithms to enable proactive threat detection and hunting.

## Elastic Integrations for behavioral detection use cases

Behavioral detection integrations provide a convenient way to enable behavioral detection capabilities. They streamline the deployment of components that implement behavioral detection, such as data ingestion, transforms, rules, machine learning jobs, and scripts.
<admonition title="Requirements">
  - In Elastic Stack, behavioral detection integrations require a [Platinum subscription](https://www.elastic.co/pricing) or higher.
  - In serverless, behavioral detection integrations require the Security Analytics Complete [project feature tier](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/project-settings).
  - To learn more about the requirements for using machine learning jobs, refer to [Machine learning job and rule requirements](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/machine-learning-job-rule-requirements).
</admonition>

Here’s a list of integrations for various behavioral detection use cases:
- [Data Exfiltration Detection](https://docs.elastic.co/en/integrations/ded)
- [Domain Generation Algorithm Detection](https://docs.elastic.co/en/integrations/dga)
- [Lateral Movement Detection](https://docs.elastic.co/en/integrations/lmd)
- [Living off the Land Attack Detection](https://docs.elastic.co/en/integrations/problemchild)
- [Network Beaconing Identification](https://docs.elastic.co/en/integrations/beaconing)

To learn more about machine learning jobs enabled by these integrations, refer to [Security anomaly detection configurations](https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-siem).