﻿---
title: Anomaly detection in Elastic Security
description: Anomaly detection jobs identify anomalous events or patterns in your data. In a security context, they’re typically used with detection rules to trigger...
url: https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/anomaly-detection
products:
  - Elastic Cloud Serverless
  - Elastic Security
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Anomaly detection in Elastic Security
<note>
  [Machine learning](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection) functionality is available when you have the appropriate role, subscription, are using a [cloud deployment](https://cloud.elastic.co/registration?page=docs&placement=docs-body), or are testing out a **Free Trial**. Refer to [Machine learning job and rule requirements](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/machine-learning-job-rule-requirements) for more information.
</note>

Anomaly detection jobs identify anomalous events or patterns in your data. In a security context, they’re typically used with detection rules to trigger alerts when behavior deviates from baseline activity.
<tip>
  Refer to [Machine learning: Anomaly detection](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection) and [About detection rules](https://www.elastic.co/docs/solutions/security/detect-and-alert/about-detection-rules) for more background.
</tip>


## Manage machine learning jobs

If you have the appropriate role, you can use the **ML job settings** interface on the **Alerts**, **Rules**, and **Rule Exceptions** pages to view, start, and stop Elastic Security machine learning jobs.
![ML job settings UI on the Alerts page](https://www.elastic.co/docs/solutions/images/security-ml-ui.png)


### Manage machine learning detection rules

You can also check the status of machine learning detection rules, and start or stop their associated machine learning jobs:
- On the **Rules** page, the **Last response** column displays the rule’s current [status](/docs/solutions/security/detect-and-alert/manage-detection-rules#rule-status). An indicator icon (![Error icon from rules table](https://www.elastic.co/docs/solutions/images/security-rules-table-error-icon.png "title")) also appears if a required machine learning job isn’t running. Click the icon to list the affected jobs, then click **Visit rule details page to investigate** to open the rule’s details page.
  ![Rules table machine learning job error](https://www.elastic.co/docs/solutions/images/security-rules-table-ml-job-error.png)
- On a rule’s details page, check the **Definition** section to confirm whether the required machine learning jobs are running. Switch the toggles on or off to run or stop each job.
  ![Rule details page with ML job stopped](https://www.elastic.co/docs/solutions/images/security-rules-ts-ml-job-stopped.png)

<tip>
  - For instructions on creating machine learning rules, refer to [Create a machine learning rule](/docs/solutions/security/detect-and-alert/create-detection-rule#create-ml-rule).
  - Alerts generated by machine learning rules are displayed on the **Alerts** page. For more information, refer to [Manage detection alerts](https://www.elastic.co/docs/solutions/security/detect-and-alert/manage-detection-alerts).
</tip>


### Prebuilt jobs

Elastic Security comes with prebuilt machine learning anomaly detection jobs for automatically detecting host and network anomalies. The jobs are displayed in the `Anomaly Detection` interface. They are available when either:
- You ship data using [Beats](https://www.elastic.co/products/beats) or the [Elastic Agent](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend), and Kibana is configured with the required index patterns (such as `auditbeat-*`, `filebeat-*`, `packetbeat-*`, or `winlogbeat-*`) on the **Data Views** page. To find this page, navigate to **Data Views** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).

Or
- Your shipped data is ECS-compliant, and Kibana is configured with the shipped data’s index patterns on the **Data Views** page.

Or
- You install one or more of the [Advanced Analytics integrations](/docs/solutions/security/advanced-entity-analytics/behavioral-detection-use-cases#ml-integrations).

[Security anomaly detection configurations](https://www.elastic.co/docs/reference/machine-learning/ootb-ml-jobs-siem) describes all available machine learning jobs and lists their requirements. For information on tuning anomaly results to reduce the number of false positives, see [Optimizing anomaly results](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/optimizing-anomaly-results).
<note>
  Machine learning jobs look back and analyze two weeks of historical data prior to the time they are enabled. After jobs are enabled, they continuously analyze incoming data. When jobs are stopped and restarted within the two-week time frame, previously analyzed data is not processed again.
</note>


## View detected anomalies

View details of detected anomalies in the **Anomalies** data tables, available on the **Hosts**, **Network**, or **Users** pages. You can access these pages from the navigation menu or with the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
<note>
  To view the **Anomalies** table  and **Max Anomaly Score By Job** details, the user must have the `machine_learning_admin` or `machine_learning_user` role.
</note>

![Host anomalies](https://www.elastic.co/docs/solutions/images/security-host-anomalies.png)

<note>
  To adjust the `score` threshold that determines which anomalies are shown, you can modify the `securitySolution:defaultAnomalyScore` [advanced setting](https://www.elastic.co/docs/solutions/security/get-started/configure-advanced-settings).
</note>

In the **Anomalies** table, you can add entity details, like the entity or any associated influencers, into Timeline.
![Host anomalies](https://www.elastic.co/docs/solutions/images/security-host-anomaly-add-to-timeline.png)

When you click into a specific host, IP, or user name (depending on the page), you can narrow the time range to a specific anomaly. To do this, click the info icon next to a maximum anomaly score and select **Narrow to this date range**.
![Filter by Max anomaly score by job](https://www.elastic.co/docs/solutions/images/security-host-max-anomaly-score-by-job.png)

On this page, you can also add fields to Timeline by hovering over a field name and selecting the Add to timeline icon.
![Filter by Max anomaly score by job](https://www.elastic.co/docs/solutions/images/security-host-add-to-timeline.png)