﻿---
title: Elastic Security solution & project type overview
description: Elastic Security combines threat detection analytics, cloud native security, and endpoint protection capabilities in a single solution.
url: https://www.elastic.co/docs/solutions/security
products:
  - Elastic Cloud Serverless
  - Elastic Security
  - Kibana
applies_to:
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Security solution & project type overview
Elastic Security is a unified security solution that unifies SIEM (Security Information and Event Management), XDR, (Extended Detection and Response), endpoint security, and cloud security into a single platform so you can detect, prevent, and respond to cyber threats across your entire environment in near real time.
Elastic Security leverages Elasticsearch's powerful search and analytics capabilities, and Kibana's visualization and collaboration features.
By combining prevention, detection, and response capabilities, Elastic Security helps your organization reduce its security risk.
Install Elastic Security on one of our Elastic Cloud deployments or your own self-managed infrastructure.

## Use cases

Use Elastic Security to protect your systems from security threats.
<dropdown title="Use cases">
  - [**SIEM:**](https://www.elastic.co/security/siem): Elastic Security's modern SIEM provides a centralized platform for ingesting, analyzing, and managing security data from various sources.
  - [**Third-party integration support**](https://www.elastic.co/docs/solutions/security/get-started/ingest-data-to-elastic-security): Ingest data from a various tools and data sources so you can centralize your security data.
  - [**Threat detection and analytics:**](https://www.elastic.co/docs/solutions/security/detect-and-alert): Identify threats by using [prebuilt rules](https://www.elastic.co/docs/solutions/security/detect-and-alert/install-manage-elastic-prebuilt-rules) with the ability to customize or create custom detection rules, automatically detect anomalous activity with built-in machine learning jobs, or proactively search for threats using our powerful [threat hunting and interactive visualization tools](https://www.elastic.co/docs/solutions/security/investigate).
  - [**Automatic migration**](https://www.elastic.co/docs/solutions/security/get-started/automatic-migration): Migrate SIEM rules from other platforms to Elastic Security.
  - [**Endpoint protection and threat prevention**](https://www.elastic.co/docs/solutions/security/configure-elastic-defend): Automatically stop cybersecurity attacks—such as malware and ransomware—before damage and loss can occur.
  - [**AI-powered features**](https://www.elastic.co/docs/solutions/security/ai): Leverage generative AI to help enhance threat detection, assist with incident response, and improve day-to-day security operations.
  - [**Custom dashboards and visualizations**](https://www.elastic.co/docs/solutions/security/dashboards): Create custom dashboards and visualizations to gain insights into security events.
  - [**Cloud Security**](https://www.elastic.co/docs/solutions/security/cloud): Elastic Security provides the following cloud features:
    - **Cloud Security Posture Management (CSPM) and Kubernetes Security Posture Management (KSPM):** Check cloud service configurations against security benchmarks to identify and resolve misconfigurations that can be exploited.
  - **Cloud Workload Protection:** Get visibility and runtime protection for cloud workloads.
  - **Vulnerability Management:** Uncover vulnerabilities within your cloud infrastructure.
</dropdown>

If you're new to Elastic Security and want to try it out, go to [Get started with Elastic Security](https://www.elastic.co/docs/solutions/security/get-started) and [Elastic Security quickstarts](https://www.elastic.co/docs/solutions/security/get-started/quickstarts).

## Core concepts

Before diving into setup and configuration, familiarize yourself with the foundational terms and core concepts that power Elastic Security.
<dropdown title="Concepts">
  - [**Elastic Agent:**](/docs/reference/fleet#elastic-agent) A single, unified way to collect logs, metrics, and other types of data from a host. Elastic Agent can also protect hosts from security threats, query data from operating systems, and forward data from remote services or hardware.
  - [**Elastic Defend:**](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend) Elastic Security's Endpoint Detection and Response (EDR) tool that protects endpoints from malicious activity. Elastic Defend uses a combination of techniques like machine learning, behavioral analysis, and prebuilt rules to detect, prevent, and respond to threats in real-time.
  - [**Elastic Endpoint:**](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/elastic-endpoint-self-protection-features) The security component, enabled by Elastic Agent, that performs Elastic Defend's threat monitoring and prevention capabilities.
  - [**Detection engine:**](https://www.elastic.co/docs/solutions/security/detect-and-alert) The framework that detects threats by using rules to search for suspicious events in your data, and generates alerts when events meet a rule's criteria.
  - [**Detection rules:**](https://www.elastic.co/docs/solutions/security/detect-and-alert/about-detection-rules) Sets of conditions that identify potential threats and malicious activities. Rules analyze various data sources, including logs and network traffic, to detect anomalies, suspicious behaviors, or known attack patterns. Elastic Security ships out-of-the-box prebuilt rules, and you can create your own custom rules.
  - [**Alerts:**](https://www.elastic.co/docs/solutions/security/detect-and-alert/manage-detection-alerts) Notifications that are generated when rule conditions are met. Alerts include a wide range of information about potential threats, including host, user, network, and other contextual data to assist your investigation.
  - [**Machine learning and anomaly detection:**](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/anomaly-detection) Anomaly detection jobs identify anomalous events or patterns in your data. Use these with machine learning detection rules to generate alerts when behavior deviates from normal activity.
  - [**Entity analytics:**](https://www.elastic.co/docs/solutions/security/advanced-entity-analytics/overview) A threat detection feature that combines the power of Elastic’s detection engine and machine learning capabilities to identify unusual behavior for hosts, users, and services.
  - [**Cases:**](https://www.elastic.co/docs/solutions/security/investigate/cases) Allows you to collect and share information about security issues. Opening a case lets you track key investigation details and collect alerts in a central location. You can also send cases to external systems.
  - [**Timeline:**](https://www.elastic.co/docs/solutions/security/investigate/timeline) Investigate security events so you can gather and analyze data related to alerts or suspicious activity. You can add events to Timeline from various sources, build custom queries, and import/export a Timeline to collaborate and share.
  - [**Security posture management:**](https://www.elastic.co/docs/solutions/security/cloud) Includes native cloud security features, such as Cloud Security Posture Management (CSPM) and Cloud Native Vulnerability Management (CNVM), that help you evaluate your cloud infrastructure's configuration against security best practices and identify vulnerabilities. You can use Elastic's native tools or ingest third-party cloud security data and incorporate it into Elastic Security's workflows.
  - [**AI Assistant:**](https://www.elastic.co/docs/solutions/security/ai/ai-assistant) Helps with tasks like alert investigation, incident response, and query generation. It utilizes natural language processing and knowledge retrieval to provide context-aware assistance, summarize threats, suggest next steps, and automate workflows. Use AI Assistant to better understand and respond to security incidents.
  - [**Attack Discovery:**](https://www.elastic.co/docs/solutions/security/ai/attack-discovery) Uses large language models (LLMs) to analyze security alerts, identify coordinated attack patterns, and provide actionable intelligence to security operations teams. It improves alert triage efficiency by automatically correlating related alerts into comprehensive, simplified threat summaries, allowing you to quickly understand and respond to the most impactful attacks.
  - [**Elastic AI SOC Engine (EASE):**](https://www.elastic.co/docs/solutions/security/ai/ease/ease-intro) Integrates Elastic's AI-powered security tools into existing SIEM and EDR/XDR platforms to help mitigate alert fatigue, accelerate threat investigations, and improve response efficiency (Serverless only).
</dropdown>


## Related reference

- [Elastic Security reference documentation](https://www.elastic.co/docs/reference/security)
- [Elastic Security API documentation](https://www.elastic.co/docs/solutions/security/apis)
- [Fleet and Elastic Agent](https://www.elastic.co/docs/reference/fleet/)

Browse the latest [Elastic Security release notes](https://www.elastic.co/docs/release-notes/security) for more information on new features, enhancements, and fixes.