﻿---
title: Sparse vector search in Elasticsearch
description: When working with sparse vectors in Elasticsearch, you'll use the Elastic Learned Sparse Encoder (ELSER) at index and query time to expand content into...
url: https://www.elastic.co/docs/solutions/search/vector/sparse-vector
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Sparse vector search in Elasticsearch
When working with sparse vectors in Elasticsearch, you'll use the [**Elastic Learned Sparse Encoder (ELSER)**](https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-elser) at index and query time to expand content into semantically related, weighted terms.
This approach preserves explainability while adding semantic understanding, with each document or query expanded into a set of weighted terms.
Sparse vector search with ELSER is ideal for:
- Enhanced keyword search with semantic expansion
- Use cases requiring explainable results
- Domain-specific search
- Large-scale deployments


## Working with sparse vectors in Elasticsearch

<tip>
  Using the `semantic_text` field type provides automatic model management and sensible defaults. [Learn more](https://www.elastic.co/docs/solutions/search/semantic-search/semantic-search-semantic-text).
</tip>

Sparse vector search with ELSER expands both documents and queries into weighted terms. To use sparse vectors in Elasticsearch:
1. **Index documents with ELSER**
   - Deploy and configure the ELSER model
- Use the `sparse_vector` field type
- See [this overview](/docs/solutions/search/semantic-search#using-nlp-models) for implementation options
2. **Query the index** using the [`sparse_vector` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-sparse-vector-query).