﻿---
title: Dense vector search in Elasticsearch
description: Dense vectors use neural embeddings to represent semantic meaning. They translate text, images, or other data into fixed-length vectors of floating-point...
url: https://www.elastic.co/docs/solutions/search/vector/dense-vector
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Dense vector search in Elasticsearch
Dense vectors use neural embeddings to represent semantic meaning. They translate text, images, or other data into fixed-length vectors of floating-point numbers. Content with similar meaning is mapped to nearby points in vector space, making dense vector search a powerful technique for:
- Finding semantically similar content
- Matching natural language questions with relevant answers
- Performing image and multimedia similarity search
- Delivering content-based recommendations


## Working with dense vectors in Elasticsearch

<tip>
  For most use cases, the [`semantic_text` field type](https://www.elastic.co/docs/solutions/search/semantic-search/semantic-search-semantic-text) is the recommended starting point. It provides automatic model management and sensible defaults for vector search.
</tip>

To implement dense vector search in Elasticsearch, you need both an index configuration and a way to generate embeddings:
1. **Index documents with embeddings**
   - Generate embeddings directly in Elasticsearch
  - Refer to the [overview of NLP model options](/docs/solutions/search/semantic-search#using-nlp-models)
- Or [bring your own embeddings](https://www.elastic.co/docs/solutions/search/vector/bring-own-vectors)
  - Store them using the `dense_vector` field type
2. **Query the index with k-NN search**
   - Use the [`knn` query](https://www.elastic.co/docs/solutions/search/vector/knn) to retrieve results based on vector similarity


### General purpose and vector optimized projects

<applies-to>
  - Elastic Cloud Serverless: Generally available
</applies-to>

When you use the [API](https://www.elastic.co/docs/api/doc/elastic-cloud-serverless/operation/operation-createelasticsearchproject) to create an Elasticsearch Serverless project, you can choose between two profiles: `general_purpose` and `vector`.
The general purpose profile is recommended for most search use cases, including full text search, sparse vectors, and dense vectors that use compression such as BBQ.
The vector profile is recommended only when your use case is based on uncompressed dense vectors with high dimensionality.
For more information about how the profile affects virtual compute unit (VCU) allocation and costs, refer to [Elasticsearch Serverless billing dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/elasticsearch-billing-dimensions).

## Better Binary Quantization (BBQ)

Better Binary Quantization (BBQ) is an advanced vector quantization technique for `dense_vector` fields. It compresses embeddings into compact binary form, enabling faster similarity search and reducing memory usage. This improves both search relevance and cost efficiency, especially when used with HNSW (Hierarchical Navigable Small World).
Learn more about how BBQ works, supported algorithms, and configuration examples in the [Better Binary Quantization (BBQ) documentation](https://www.elastic.co/docs/reference/elasticsearch/index-settings/bbq).