﻿---
title: Vector search in Elasticsearch
description: Vector search in Elasticsearch uses vector embeddings to power modern, AI-driven search experiences. With vectorized content, Elasticsearch retrieves...
url: https://www.elastic.co/docs/solutions/search/vector
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Vector search in Elasticsearch
<tip>
  Looking for a minimal configuration approach? The `semantic_text` field type provides an abstraction over vector search implementations with sensible defaults and automatic model management. It's the recommended way to start with Elasticsearch vector search. [Learn more about semantic_text](https://www.elastic.co/docs/solutions/search/semantic-search/semantic-search-semantic-text).
</tip>

Vector search in Elasticsearch uses vector embeddings to power modern, AI-driven search experiences. With vectorized content, Elasticsearch retrieves results based on meaning and similarity, not just keywords or exact term matches.
Vector search is a core component of most [semantic search](https://www.elastic.co/docs/solutions/search/semantic-search) workflows, but it can also be used independently for similarity matching use cases. Learn more about the broader benefits in the [AI-powered search overview](https://www.elastic.co/docs/solutions/search/ai-search/ai-search).
This guide focuses on the more manual technical implementations of vector search, outside of the higher-level `semantic_text` workflow.

The right approach depends on your requirements, data type, and use case.

## Vector queries and field types in Elasticsearch

Here’s a quick reference for the main **vector field types** and **query types** you can use:

| Vector type     | Field type      | Query type      | Primary use case                                            |
|-----------------|-----------------|-----------------|-------------------------------------------------------------|
| Dense vectors   | `dense_vector`  | `knn`           | Semantic similarity with your own embeddings model          |
| Sparse vectors  | `sparse_vector` | `sparse_vector` | Semantic term expansion using the ELSER model               |
| Sparse or dense | `semantic_text` | `semantic`      | Managed semantic search, agnostic to implementation details |


## Dense vector search in Elasticsearch

Dense vector search uses neural embeddings to capture semantic meaning. It translates content into fixed-length numeric vectors, where similar items cluster close together in vector space. This makes dense vectors ideal for:
- Finding semantically similar documents
- Matching user questions with answers
- Image and multimedia similarity search
- Content-based recommendations

[Learn more about dense vector search in Elasticsearch](https://www.elastic.co/docs/solutions/search/vector/dense-vector).

## Sparse vector search with ELSER

Sparse vector search relies on the **ELSER model** to expand content with semantically related terms. This approach combines semantic understanding with explainability, making it a strong fit for:
- Enhanced keyword search
- Use cases requiring explainable results
- Domain-specific search
- Large-scale deployments

[Learn more about sparse vector search with ELSER](https://www.elastic.co/docs/solutions/search/vector/sparse-vector).