﻿---
title: What is Search UI?
description: Search UI is a JavaScript library from Elastic. It helps you create modern and customizable search experiences. You can use it with Elasticsearch or other...
url: https://www.elastic.co/docs/solutions/search/site-or-app/search-ui
products:
  - Search UI
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# What is Search UI?
Search UI is a JavaScript library from [Elastic](https://www.elastic.co/). It helps you create modern and customizable search experiences. You can use it with Elasticsearch or other search APIs. It helps developers build complete search interfaces quickly, with minimal boilerplate.
As a headless library, Search UI separates logic from presentation. You can use it with React, vanilla JavaScript, or any front-end framework. You can use built-in React components for quick development. Or, you can create your own from the ground up.
Search UI supports advanced capabilities like customizable query behavior, smart URL handling (capturing filters, paging, and queries in the URL), and flexible backend integration through connectors. It works seamlessly with Elasticsearch and also supports custom backends via custom connectors.
<important>
  Enterprise Search is not available in Elastic Stack 9.0+.
</important>


## Get started

- [Reference documentation](https://www.elastic.co/docs/reference/search-ui): API docs, tutorials, and usage guides
  - [Quickstart tutorials](https://www.elastic.co/docs/reference/search-ui/tutorials)
- [Ecommerce examples](https://www.elastic.co/docs/reference/search-ui/ecommerce)
- [Basic usage](https://www.elastic.co/docs/reference/search-ui/basic-usage)
- [API reference](https://www.elastic.co/docs/reference/search-ui/api-reference)
- [GitHub repository](https://github.com/elastic/search-ui): Source code, examples, and issue tracking


## Live demos


### Connectors

- [Elasticsearch](https://codesandbox.io/s/github/elastic/search-ui/tree/main/examples/sandbox?from-embed=&initialpath=/elasticsearch&file=/src/pages/elasticsearch/index.js)
- [Elastic Site Search (Swiftype)](https://codesandbox.io/s/github/elastic/search-ui/tree/main/examples/sandbox?from-embed=&initialpath=/site-search&file=/src/pages/site-search/index.js)


### Examples

- [Search as you type](https://codesandbox.io/s/github/elastic/search-ui/tree/main/examples/sandbox?from-embed=&initialpath=/search-as-you-type&file=/src/pages/search-as-you-type/index.js)
- [Search bar in header](https://codesandbox.io/s/github/elastic/search-ui/tree/main/examples/sandbox?from-embed=&initialpath=/search-bar-in-header&file=/src/pages/search-bar-in-header/index.js)
- [Customizing Styles and Components](https://codesandbox.io/s/github/elastic/search-ui/tree/main/examples/sandbox?from-embed=&initialpath=/customizing-styles-and-html&file=/src/pages/customizing-styles-and-html/index.js)