﻿---
title: Semantic search
description: Elasticsearch provides various semantic search capabilities using natural language processing (NLP) and vector search. To understand the infrastructure...
url: https://www.elastic.co/docs/solutions/search/semantic-search
products:
  - Elastic Cloud Serverless
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Semantic search
<note>
  This page focuses on the semantic search workflows available in Elasticsearch. For detailed information about lower-level vector search implementations, refer to [vector search](https://www.elastic.co/docs/solutions/search/vector).
</note>

Elasticsearch provides various semantic search capabilities using [natural language processing (NLP)](https://www.elastic.co/docs/explore-analyze/machine-learning/nlp) and [vector search](https://www.elastic.co/docs/solutions/search/vector).
To understand the infrastructure that powers semantic search and other NLP tasks, including managed services and inference endpoints, see the [Elastic Inference overview](https://www.elastic.co/docs/explore-analyze/elastic-inference) page.
Learn more about use cases for AI-powered search in the [overview](https://www.elastic.co/docs/solutions/search/ai-search/ai-search) page.

## Overview of semantic search workflows

You have several options for using NLP models for semantic search in the Elastic Stack:
- [Option 1](#_semantic_text_workflow): Use the `semantic_text` workflow (recommended)
- [Option 2](#_infer_api_workflow): Use the inference API workflow
- [Option 3](#_model_deployment_workflow): Deploy models directly in Elasticsearch

This diagram summarizes the relative complexity of each workflow:
![Overview of semantic search workflows in Elasticsearch](https://www.elastic.co/docs/solutions/images/elasticsearch-reference-semantic-options.svg)


## Choose a semantic search workflow


### Option 1: `semantic_text`

The simplest way to use NLP models in the Elastic Stack is through the [`semantic_text` workflow](https://www.elastic.co/docs/solutions/search/semantic-search/semantic-search-semantic-text). We recommend using this approach because it abstracts away a lot of manual work. All you need to do is create an index mapping to start ingesting, embedding, and querying data. There is no need to define model-related settings and parameters, or to create inference ingest pipelines. For guidance on the available query types for `semantic_text`, see [Querying `semantic_text` fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text-search-retrieval).
To learn more about supported services, refer to [Inference integrations](https://www.elastic.co/docs/explore-analyze/elastic-inference/inference-api) and the [inference API](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-inference) documentation. For an end-to-end tutorial, refer to [Semantic search with `semantic_text`](https://www.elastic.co/docs/solutions/search/semantic-search/semantic-search-semantic-text).

### Option 2: Inference API

The inference API workflow is more complex but offers greater control over the inference endpoint configuration. You need to create an inference endpoint, provide various model-related settings and parameters, and define an index mapping. Optionally you can also set up an inference ingest pipeline for automatic embedding during data ingestion, or alternatively, you can manually call the inference API.
For an end-to-end tutorial, refer to [Semantic search with the inference API](https://www.elastic.co/docs/solutions/search/semantic-search/semantic-search-inference).

### Option 3: Manual model deployment

You can also deploy NLP in Elasticsearch manually, without using an inference endpoint. This is the most complex and labor intensive workflow for performing semantic search in the Elastic Stack. You need to select an NLP model from the [list of supported dense and sparse vector models](/docs/explore-analyze/machine-learning/nlp/ml-nlp-model-ref#ml-nlp-model-ref-text-embedding), deploy it using the Eland client, create an index mapping, and set up a suitable ingest pipeline to start ingesting and querying data.
For an end-to-end tutorial, refer to [Semantic search with a model deployed in Elasticsearch](https://www.elastic.co/docs/solutions/search/vector/dense-versus-sparse-ingest-pipelines).
<tip>
  Refer to [vector queries and field types](/docs/solutions/search/vector#vector-queries-and-field-types) for a quick reference overview.
</tip>


## Learn more


### Interactive examples

- The [`elasticsearch-labs`](https://github.com/elastic/elasticsearch-labs) repo contains a number of interactive semantic search examples in the form of executable Python notebooks, using the Elasticsearch Python client
- [Semantic search with ELSER using the model deployment workflow](https://github.com/elastic/elasticsearch-labs/blob/main/notebooks/search/03-ELSER.ipynb)
- [Semantic search with `semantic_text`](https://github.com/elastic/elasticsearch-labs/blob/main/notebooks/search/09-semantic-text.ipynb)


### Blogs

- [Elasticsearch new semantic_text mapping: Simplifying semantic search](https://www.elastic.co/search-labs/blog/semantic-search-simplified-semantic-text)
- [GA information for `semantic_text`](https://www.elastic.co/search-labs/blog/semantic-text-ga)
- [Introducing ELSER: Elastic's AI model for semantic search](https://www.elastic.co/blog/may-2023-launch-sparse-encoder-ai-model)
- [How to get the best of lexical and AI-powered search with Elastic's vector database](https://www.elastic.co/blog/lexical-ai-powered-search-elastic-vector-database)
- Information retrieval blog series:
  - [Part 1: Steps to improve search relevance](https://www.elastic.co/blog/improving-information-retrieval-elastic-stack-search-relevance)
- [Part 2: Benchmarking passage retrieval](https://www.elastic.co/blog/improving-information-retrieval-elastic-stack-benchmarking-passage-retrieval)
- [Part 3: Introducing Elastic Learned Sparse Encoder, our new retrieval model](https://www.elastic.co/blog/may-2023-launch-information-retrieval-elasticsearch-ai-model)
- [Part 4: Hybrid retrieval](https://www.elastic.co/blog/improving-information-retrieval-elastic-stack-hybrid)