﻿---
title: Search approaches
description: To deliver relevant search results, you need to choose the right search approach for your data and use case. The following table provides an overview...
url: https://www.elastic.co/docs/solutions/search/search-approaches
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Search approaches
To deliver relevant search results, you need to choose the right search approach for your data and use case.

## Overview of search techniques

The following table provides an overview of the fundamental search techniques available in Elasticsearch:

| Name                                                                                      | Description                                                        | Notes                                                                                                                                                                        |
|-------------------------------------------------------------------------------------------|--------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [**Full-text search**](https://www.elastic.co/docs/solutions/search/full-text)            | Traditional lexical search with analyzers and relevance tuning     | Essential foundation for keyword matching, works out of the box                                                                                                              |
| [**AI-powered search**](https://www.elastic.co/docs/solutions/search/ai-search/ai-search) | Machine learning-based search using natural language understanding | Includes [vector search](https://www.elastic.co/docs/solutions/search/vector) and [semantic search](https://www.elastic.co/docs/solutions/search/semantic-search) approaches |
| [**Hybrid search**](https://www.elastic.co/docs/solutions/search/hybrid-search)           | Combines lexical and vector/semantic approaches                    | Best balance for both keyword precision and semantic relevance                                                                                                               |
| [**Ranking and reranking**](https://www.elastic.co/docs/solutions/search/ranking)         | Post-processing results to improve relevance                       | Optional ML-based enhancement for fine-tuned relevance                                                                                                                       |
| [**Geospatial search**](https://www.elastic.co/docs/explore-analyze/geospatial-analysis)  | Location-based search and spatial relationships                    | For maps, distance calculations, and shape queries                                                                                                                           |

<tip>
  Full-text search is a very powerful tool in itself. One of the key strengths of Elasticsearch is its flexibility, allowing you to start with full-text search and gradually incorporate more complex or resource-intensive approaches over time.
</tip>


## Next step

Once you've chosen your search approach(es), you'll need to select a query language to implement them. Refer to [query languages for search use cases](https://www.elastic.co/docs/solutions/search/querying-for-search) to learn about the available options.