﻿---
title: Retrievers
description: A retriever is an abstraction that was added to the _search API in 8.14.0 and was made generally available in 8.16.0. This syntax enables the configuration...
url: https://www.elastic.co/docs/solutions/search/retrievers-overview
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Retrievers
A retriever is an abstraction that was added to the `_search` API in **8.14.0** and was made generally available in **8.16.0**.
This syntax enables the configuration of multi-stage retrieval pipelines within a single `_search` call. This simplifies your search application logic, because you no longer need to configure complex searches via multiple Elasticsearch calls or implement additional client-side logic to combine results from different queries.
<note>
  This document provides a general overview of the retriever abstraction. For a full syntax reference and implementation overview, check out the [reference documentation](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers).
</note>


## Retriever types

Retrievers come in various types, each tailored for different search operations. The following retrievers are currently available:
- [**kNN retriever**](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/knn-retriever). Returns top documents from a [knn search](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search#search-api-knn), in the context of a retriever framework.
- [**Linear retriever**](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/linear-retriever). Combines the top results from multiple sub-retrievers using a weighted sum of their scores.
- [**Pinned retriever**](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/pinned-retriever). Always places specified documents at the top of the results, with the remaining hits provided by a secondary retriever.
- [**Rescorer retriever**](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/rescorer-retriever). Re-scores the results produced by its child retriever.
- [**RRF retriever**](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/rrf-retriever). Compound retriever which combines and ranks multiple first-stage retrievers using the reciprocal rank fusion (RRF) algorithm.
- [**Rule retriever**](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/rule-retriever). Applies [query rules](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/searching-with-query-rules#query-rules) to the query before returning results.
- [**Standard retriever**](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/standard-retriever). Returns top documents from a traditional [query](https://www.elastic.co/docs/explore-analyze/query-filter/languages/querydsl).
- [**Text Similarity Re-ranker retriever**](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/text-similarity-reranker-retriever). Used for semantic reranking.


## What makes retrievers useful?

Here’s an overview of what makes retrievers useful and how they differ from regular queries.
1. **Simplified user experience**. Retrievers simplify the user experience by allowing entire retrieval pipelines to be configured in a single API call. This maintains backward compatibility with traditional query elements by automatically translating them to the appropriate retriever.
2. **Structured retrieval**. Retrievers provide a more structured way to define search operations. They allow searches to be described using a "retriever tree", a hierarchical structure that clarifies the sequence and logic of operations, making complex searches more understandable and manageable.
3. **Composability and flexibility**. Retrievers enable flexible composability, allowing you to build pipelines and seamlessly integrate different retrieval strategies into these pipelines. Retrievers make it easy to test out different retrieval strategy combinations.
4. **Compound operations**. A retriever can have sub retrievers. This allows complex nested searches where the results of one retriever feed into another, supporting sophisticated querying strategies that might involve multiple stages or criteria.
5. **Retrieval as a first-class concept**. Unlike traditional queries, where the query is a part of a larger search API call, retrievers are designed as standalone entities that can be combined or used in isolation. This enables a more modular and flexible approach to constructing searches.
6. **Enhanced control over document scoring and ranking**. Retrievers allow for more explicit control over how documents are scored and filtered. For instance, you can specify minimum score thresholds, apply complex filters without affecting scoring, and use parameters like `terminate_after` for performance optimizations.
7. **Integration with existing Elasticsearch functionalities**. Even though retrievers can be used instead of existing `_search` API syntax (like the `query` and `knn`), they are designed to integrate seamlessly with things like pagination (`search_after`) and sorting. They also maintain compatibility with aggregation operations by treating the combination of all leaf retrievers as `should` clauses in a boolean query.
8. **Cleaner separation of concerns**. When using compound retrievers, only the query element is allowed, which enforces a cleaner separation of concerns and prevents the complexity that might arise from overly nested or interdependent configurations.


## Example

The following example demonstrates how using retrievers simplify the composability of queries for RRF ranking.
```js
GET example-index/_search
{
  "retriever": {
    "rrf": {
      "retrievers": [
        {
          "standard": {
            "query": {
              "sparse_vector": {
                "field": "vector.tokens",
                "inference_id": "my-elser-endpoint",
                "query": "What blue shoes are on sale?"
              }
            }
          }
        },
        {
          "standard": {
            "query": {
              "match": {
                "text": "blue shoes sale"
              }
            }
          }
        }
      ]
    }
  }
}
```

This example demonstrates how you can combine different retrieval strategies into a single `retriever` pipeline.
Compare to `RRF` with `sub_searches` approach (which is deprecated as of 8.16.0):
<dropdown title="Expand for example">
  ```js
  GET example-index/_search
  {
    "sub_searches":[
      {
        "query":{
          "match":{
            "text":"blue shoes sale"
          }
        }
      },
      {
        "query":{
          "sparse_vector": {
              "field": "vector.tokens",
              "inference_id": "my-elser-endoint",
              "query": "What blue shoes are on sale?"
            }
          }
        }
    ],
    "rank":{
      "rrf":{
        "rank_window_size":50,
        "rank_constant":20
      }
    }
  }
  ```
</dropdown>

For more examples, refer to [retriever examples](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/retrievers-examples).

## Glossary

Here are some important terms:
- **Retrieval Pipeline**. Defines the entire retrieval and ranking logic to produce top hits.
- **Retriever Tree**. A hierarchical structure that defines how retrievers interact.
- **First-stage Retriever**. Returns an initial set of candidate documents.
- **Compound Retriever**. Builds on one or more retrievers, enhancing document retrieval and ranking logic.
- **Combiners**. Compound retrievers that merge top hits from multiple sub-retrievers.
- **Rerankers**. Special compound retrievers that reorder hits and may adjust the number of hits, with distinctions between first-stage and second-stage rerankers.


## Test retriever syntax in Playground

<applies-to>
  - Serverless Elasticsearch projects: Beta
  - Elastic Stack: Beta
</applies-to>

Playground builds Elasticsearch queries using the retriever abstraction. It automatically detects the fields and types in your index and builds a retriever tree based on your selections.
You can use the Playground to experiment with different retriever configurations and observe how they affect search results.
Refer to the [Playground documentation](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/playground) for more information.

## Reference docs and examples

For implementation details, including notable restrictions, refer to the [reference documentation](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers).
For additional examples, refer to [Retrievers examples](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/retrievers-examples).