﻿---
title: Search using LTR
description: Once your LTR model is trained and deployed in Elasticsearch, there are two ways to use it with the search API to improve your search results: As a rescorer,...
url: https://www.elastic.co/docs/solutions/search/ranking/learning-to-rank-search-usage
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Search using LTR
<note>
  This feature was introduced in version 8.12.0 and is only available to certain subscription levels. For more information, see https://www.elastic.co/subscriptions.
</note>

Once your LTR model is trained and deployed in Elasticsearch, there are two ways to use it with the [search API](https://www.elastic.co/docs/solutions/search/querying-for-search) to improve your search results:
1. **As a [rescorer](#learning-to-rank-rescorer)**
2. **As a [retriever](#learning-to-rank-retriever)**


## Learning To Rank as a rescorer

To use your LTR model as a [rescorer](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/rescore-search-results) in the [search API](https://www.elastic.co/docs/solutions/search/querying-for-search), follow this example:
```json

{
  "query": { <1>
    "multi_match": {
      "fields": ["title", "content"],
      "query": "the quick brown fox"
    }
  },
  "rescore": {
    "learning_to_rank": {
      "model_id": "ltr-model", <2>
      "params": { <3>
        "query_text": "the quick brown fox"
      }
    },
    "window_size": 100 <4>
  }
}
```


## Learning To Rank as a retriever

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
</applies-to>

LTR models can also be used as a [retriever](https://www.elastic.co/docs/solutions/search/retrievers-overview) in the search pipeline. You can implement this with a [rescorer retriever](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/rescorer-retriever) as shown in the following example:
```json

{
  "retriever": {
    "rescorer": {
      "rescore": {
        "window_size": 100, <4>
        "learning_to_rank": {
          "model_id": "ltr-model", <2>
          "params": { <3>
            "query_text": "the quick brown fox"
          }
        }
      },
      "retrievers": [ <1>
        {
          "standard": {
            "query": {
              "multi_match": {
                "fields": ["title", "content"],
                "query": "the quick brown fox"
              }
            }
          }
        }
      ]
    }
  }
}
```


## Known limitations


### Rescore window size

Scores returned by LTR models are usually not comparable with the scores issued by the first pass query and can be lower than the non-rescored score. This can cause the non-rescored result document to be ranked higher than the rescored document. To prevent this, the `window_size` parameter is mandatory for LTR rescorers and should be greater than or equal to `from + size`.

### Pagination

When exposing pagination to users, `window_size` should remain constant as each page is progressed by passing different `from` values. Changing the `window_size` can alter the top hits causing results to confusingly shift as the user steps through pages.