﻿---
title: Build your search queries
description: Once you know which search approaches you need to use, you can start building and testing your search queries. Elasticsearch provides several query languages...
url: https://www.elastic.co/docs/solutions/search/querying-for-search
products:
  - Elastic Cloud Serverless
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Build your search queries
<tip>
  This page is focused on the search use case. For an overview of Elastic query languages for every use case, refer to the [complete overview](https://www.elastic.co/docs/explore-analyze/query-filter/languages).
</tip>

Once you know which [search approaches](https://www.elastic.co/docs/solutions/search/search-approaches) you need to use, you can start building and testing your search queries. Elasticsearch provides several query languages to help you express your search logic.

| Interface                                                                                    | Endpoint                                                                 | Description                                                                               | Best for                                                                                                                                                                               |
|----------------------------------------------------------------------------------------------|--------------------------------------------------------------------------|-------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [**Query DSL**](https://www.elastic.co/docs/explore-analyze/query-filter/languages/querydsl) | [`_search`](https://www.elastic.co/docs/solutions/search/the-search-api) | Original, JSON-based query language native to Elasticsearch. Powerful but complex syntax. | Full-text and semantic search queries                                                                                                                                                  |
| [**ES|QL**](https://www.elastic.co/docs/solutions/search/esql-for-search)                    | `_query`                                                                 | Fast, SQL-like language with piped syntax, built on new compute architecture.             | Filtering, analysis, aggregations                                                                                                                                                      |
| [**Retrievers**](https://www.elastic.co/docs/solutions/search/retrievers-overview)           | `_search`                                                                | Modern `_search` API syntax focused on composability.                                     | Building complex search pipelines, especially those using semantic search. Required for [semantic reranking](https://www.elastic.co/docs/solutions/search/ranking/semantic-reranking). |

These query languages are complementary, not mutually exclusive. You can use different query languages for different parts of your application, based on your specific needs. This flexibility allows you to gradually adopt newer interfaces as your requirements evolve.
<note>
  You can use the [Elasticsearch REST APIs](https://www.elastic.co/docs/api/doc/elasticsearch) to search your data using any HTTP client, including the [Elasticsearch client libraries](https://www.elastic.co/docs/solutions/search/site-or-app/clients), or directly in [Console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console). You can also run searches using [Discover](https://www.elastic.co/docs/explore-analyze/discover) in the UI.
</note>

<tip>
  Try our hands-on [quickstart guides](https://www.elastic.co/docs/solutions/search/get-started/quickstarts) to get started, or check out our [Python notebooks](https://github.com/elastic/elasticsearch-labs/tree/main/notebooks#readme).
</tip>