﻿---
title: Hybrid search
description: Hybrid search combines traditional full-text search with AI-powered search for more powerful search experiences that serve a wider range of user needs...
url: https://www.elastic.co/docs/solutions/search/hybrid-search
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Hybrid search
Hybrid search combines traditional [full-text search](https://www.elastic.co/docs/solutions/search/full-text) with [AI-powered search](https://www.elastic.co/docs/solutions/search/ai-search/ai-search) for more powerful search experiences that serve a wider range of user needs.
The recommended way to use hybrid search in the Elastic Stack is following the `semantic_text` workflow. Check out the [hands-on tutorial](https://www.elastic.co/docs/solutions/search/hybrid-semantic-text) for a step-by-step guide.
We recommend implementing hybrid search with the [reciprocal rank fusion (RRF)](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/reciprocal-rank-fusion) algorithm. This approach merges rankings from both semantic and lexical queries, giving more weight to results that rank high in either search. This ensures that the final results are balanced and relevant.