﻿---
title: Quickstarts
description: Quickstarts reduce your time-to-value by offering a fast path to learn about search strategies. Each quickstart provides: A highly opinionated, fast path...
url: https://www.elastic.co/docs/solutions/search/get-started/quickstarts
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Quickstarts
Quickstarts reduce your time-to-value by offering a fast path to learn about search strategies.
Each quickstart provides:
- A highly opinionated, fast path to a specific use case
- Sensible configuration defaults with minimal configuration required

Follow the steps in these guides to get started quickly:
- [Index and search basics](https://www.elastic.co/docs/solutions/search/get-started/index-basics)
- [Build your first search query with Python](https://www.elastic.co/docs/solutions/search/get-started/keyword-search-python)
- [Get started with semantic search](https://www.elastic.co/docs/solutions/search/get-started/semantic-search)


## Related resources

The following resources go deeper into specific features or use cases:
- [Get started with Query DSL search and filters](https://www.elastic.co/docs/reference/query-languages/query-dsl/full-text-filter-tutorial)
- [Get started with ES|QL queries](https://www.elastic.co/docs/reference/query-languages/esql/esql-getting-started)
- [Analyze eCommerce data with aggregations using Query DSL](https://www.elastic.co/docs/explore-analyze/query-filter/aggregations/tutorial-analyze-ecommerce-data-with-aggregations-using-query-dsl)
- [Hybrid search with semantic_text](https://www.elastic.co/docs/solutions/search/hybrid-semantic-text)
- [Bring your own dense vectors to Elasticsearch](https://www.elastic.co/docs/solutions/search/vector/bring-own-vectors)