﻿---
title: Get started with search
description: Get started with the search use case using the core Elasticsearch search features available on any deployment type.
url: https://www.elastic.co/docs/solutions/search/get-started
products:
  - Elastic Cloud Serverless
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Get started with search
New to search with Elasticsearch? Start building a search experience by setting up your first deployment, refining your search goals, and adding data. **These core search capabilities are available to you regardless of your deployment type, solution, or project type.**
<note>
  If you're looking for an introduction to the Elastic Stack or the Elasticsearch product, go to [Elastic fundamentals](https://www.elastic.co/docs/get-started) or [The Elasticsearch data store](https://www.elastic.co/docs/manage-data/data-store).
</note>

<stepper>
  <step title="Choose your deployment type">
    Elastic provides several self-managed and Elastic-managed options.
    For simplicity and speed, try out Elastic Cloud Serverless:
    <dropdown title="Create a serverless project">
      There are two options to create serverless projects:
      - If you are a new user, [sign up for a free 14-day trial](https://cloud.elastic.co/serverless-registration) to create a serverless project. For more information about the Elastic Cloud trials, check [Trial features](/docs/deploy-manage/deploy/elastic-cloud/create-an-organization#general-sign-up-trial-what-is-included-in-my-trial).
      - If you are an existing customer, [log in to Elastic Cloud](https://cloud.elastic.co/login). On the home page, you will see a new option to create serverless projects. The `admin` predefined role or an equivalent custom role is required to create projects. Refer to [User roles and privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles).
      If you're not sure which project type to choose, select the **Elasticsearch** project type. This project type provides core Elasticsearch search capabilities along with additional UI tools to help you build search-powered applications faster.When your project is created, you're ready to move on to the next step and to start creating indices, adding data, and performing searches.
    </dropdown>
    Alternatively, create a [local development installation](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/local-development-installation-quickstart) in Docker:
    ```sh
    curl -fsSL https://elastic.co/start-local | sh
    ```
    Check out the full list of [deployment types](/docs/deploy-manage/deploy#choosing-your-deployment-type) to learn more.
  </step>

  <step title="(Optional) Try out a quickstart">
    Get hands-on experience with Elasticsearch using guided tutorials that walk you through common search scenarios:
    - [**Index and search basics**](https://www.elastic.co/docs/solutions/search/get-started/index-basics): Learn how to create indices, add documents, and perform searches
    - [**Keyword search with Python**](https://www.elastic.co/docs/solutions/search/get-started/keyword-search-python): Build your first search query with Python
    - [**Semantic search**](https://www.elastic.co/docs/solutions/search/get-started/semantic-search): Implement semantic search using embeddings
  </step>

  <step title="Identify your search goals">
    Depending on your use case, you can choose multiple [search approaches](https://www.elastic.co/docs/solutions/search/search-approaches), for example full-text and semantic search.
    Each approach affects your options for storing and querying your data.If you're unsure which approaches match your goals, you can try them out with sample data. For example, [Get started with semantic search](https://www.elastic.co/docs/solutions/search/get-started/semantic-search).If you prefer to ingest your data first and transform or reindex it as needed later, skip to the next step.
  </step>

  <step title="Ingest your data">
    If your goals include vector or semantic AI-powered search, create vectorized data with built-in and third-party natural language processing (NLP) models and store it in an Elasticsearch vector database.
    The approach that requires the least configuration involves adding `semantic_text` fields when ingesting your data.
    This method is described in [Semantic search with semantic_text](https://www.elastic.co/docs/solutions/search/semantic-search/semantic-search-semantic-text).To learn about adding data for other search goals, go to [Ingest for search use cases](https://www.elastic.co/docs/solutions/search/ingest-for-search).
    For a broader overview of ingestion options, go to [Ingest: Bring your data to Elastic](https://www.elastic.co/docs/manage-data/ingest).If you're not ready to add your own data, you can use [sample data](https://www.elastic.co/docs/manage-data/ingest/sample-data) or create small data sets when you follow the instructions in the [quickstarts](https://www.elastic.co/docs/solutions/search/get-started/quickstarts).The Elasticsearch home page in the UI also provides workflow guides for creating indices and ready-to-use code examples for ingesting data by using REST APIs.
  </step>

  <step title="Build your search queries">
    Your next steps will be to choose a method to write queries and interact with Elasticsearch.
    You can pick a programming language [client](https://www.elastic.co/docs/reference/elasticsearch-clients) that matches your application and choose which [query languages](https://www.elastic.co/docs/solutions/search/querying-for-search) you will use to express your search logic.
    Each decision builds on the previous ones, offering flexibility to mix and match approaches based on your needs.
  </step>
</stepper>


## Related resources

Use these resources to learn more about Elasticsearch or get started in a different way:
- Evaluate the [Elasticsearch solution](https://www.elastic.co/docs/solutions/elasticsearch-solution-project)
- [Detailed deployment comparison](https://www.elastic.co/docs/deploy-manage/deploy/deployment-comparison)
- [Get started with Query DSL search and filters](https://www.elastic.co/docs/reference/query-languages/query-dsl/full-text-filter-tutorial)
- [Get started with ES|QL queries](https://www.elastic.co/docs/reference/query-languages/esql/esql-getting-started)
- [Analyze eCommerce data with aggregations using Query DSL](https://www.elastic.co/docs/explore-analyze/query-filter/aggregations/tutorial-analyze-ecommerce-data-with-aggregations-using-query-dsl)