﻿---
title: Text analysis during search
description: Text analysis is the process of converting unstructured text, like the body of an email or a product description, into a structured format that’s optimized...
url: https://www.elastic.co/docs/solutions/search/full-text/text-analysis-during-search
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Text analysis during search
*Text analysis* is the process of converting unstructured text, like the body of an email or a product description, into a structured format that’s [optimized for search](https://www.elastic.co/docs/solutions/search/full-text).

## When to configure text analysis

Elasticsearch performs text analysis when indexing or searching [`text`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/text) fields.
If your index doesn’t contain `text` fields, no further setup is needed; you can skip the pages in this section.
However, if you use `text` fields or your text searches aren’t returning results as expected, configuring text analysis can often help. You should also look into analysis configuration if you’re using Elasticsearch to:
- Build a search engine
- Mine unstructured data
- Fine-tune search for a specific language
- Perform lexicographic or linguistic research


## Learn more

Learn more about text analysis in the **Manage Data** section of the documentation:
- [Overview](https://www.elastic.co/docs/manage-data/data-store/text-analysis)
- [Concepts](https://www.elastic.co/docs/manage-data/data-store/text-analysis/concepts)
- [*Configure text analysis*](https://www.elastic.co/docs/manage-data/data-store/text-analysis/configure-text-analysis)
- [*Built-in analyzer reference*](https://www.elastic.co/docs/reference/text-analysis/analyzer-reference)
- [*Tokenizer reference*](https://www.elastic.co/docs/reference/text-analysis/tokenizer-reference)
- [*Token filter reference*](https://www.elastic.co/docs/reference/text-analysis/token-filter-reference)
- [*Character filters reference*](https://www.elastic.co/docs/reference/text-analysis/character-filter-reference)
- [*Normalizers*](https://www.elastic.co/docs/reference/text-analysis/normalizers)