﻿---
title: Incorporating static relevance signals into the score
description: Many domains have static signals that are known to be correlated with relevance. For instance PageRank and url length are two commonly used features for...
url: https://www.elastic.co/docs/solutions/search/full-text/search-relevance/static-scoring-signals
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Incorporating static relevance signals into the score
Many domains have static signals that are known to be correlated with relevance. For instance [PageRank](https://en.wikipedia.org/wiki/PageRank) and url length are two commonly used features for web search in order to tune the score of web pages independently of the query.
There are two main queries that allow combining static score contributions with textual relevance, eg. as computed with BM25:
- [`script_score` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-script-score-query)
- [`rank_feature` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-rank-feature-query)

For instance imagine that you have a `pagerank` field that you wish to combine with the BM25 score so that the final score is equal to `score = bm25_score + pagerank / (10 + pagerank)`.
With the [`script_score` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-script-score-query) the query would look like this:
```json

{
  "query": {
    "script_score": {
      "query": {
        "match": { "body": "elasticsearch" }
      },
      "script": {
        "source": "_score * saturation(doc['pagerank'].value, 10)" <1>
      }
    }
  }
}
```

while with the [`rank_feature` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-rank-feature-query) it would look like below:
```json

{
  "query": {
    "bool": {
      "must": {
        "match": { "body": "elasticsearch" }
      },
      "should": {
        "rank_feature": {
          "field": "pagerank", <1>
          "saturation": {
            "pivot": 10
          }
        }
      }
    }
  }
}
```

While both options would return similar scores, there are trade-offs: [script_score](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-script-score-query) provides a lot of flexibility, enabling you to combine the text relevance score with static signals as you prefer. On the other hand, the [`rank_feature` query](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/rank-feature) only exposes a couple ways to incorporate static signals into the score. However, it relies on the [`rank_feature`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/rank-feature) and [`rank_features`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/rank-features) fields, which index values in a special way that allows the [`rank_feature` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-rank-feature-query) to skip over non-competitive documents and get the top matches of a query faster.