﻿---
title: Long running searches with the Async Search API
description: Elasticsearch generally allows you to quickly search across big amounts of data. There are situations where a search executes on many shards, possibly...
url: https://www.elastic.co/docs/solutions/search/async-search-api
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Long running searches with the Async Search API
Elasticsearch generally allows you to quickly search across big amounts of data. There are situations where a search executes on many shards, possibly against large data sets or multiple [remote clusters](https://www.elastic.co/docs/deploy-manage/remote-clusters), for which results are not expected to be returned in milliseconds. When you need to execute long-running searches, synchronously waiting for its results to be returned is not ideal. Instead, Async search lets you submit a search request that gets executed *asynchronously*, monitor the progress of the request, and retrieve results at a later stage. You can also retrieve partial results as they become available but before the search has completed.
You can submit an async search request using the [submit async search](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-async-search-submit) API. The [get async search](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-async-search-submit) API allows you to monitor the progress of an async search request and retrieve its results. An ongoing async search can be deleted through the [delete async search](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-async-search-submit) API.