﻿---
title: APIs and tools
description: This page is handy list of the most important APIs and tools you need to build, test, and manage your search app built with Elasticsearch. Access these...
url: https://www.elastic.co/docs/solutions/search/apis-and-tools
products:
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# APIs and tools
This page is handy list of the most important APIs and tools you need to build, test, and manage your search app built with Elasticsearch.

## API endpoints


### Query & search APIs


| Endpoint                                                                                                          | Function                                                                                                                                                                                                                |
|-------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [`_search`](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-search)                              | Searches and aggregations written in [Query DSL](https://www.elastic.co/docs/explore-analyze/query-filter/languages/querydsl) and [retrievers](https://www.elastic.co/docs/solutions/search/retrievers-overview) syntax |
| [`_query`](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-esql)                                 | Endpoint for [ES|QL](https://www.elastic.co/docs/reference/query-languages/esql) queries                                                                                                                                |
| [`_explain`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-explain)                       | Provides detailed explanation of how a specific document matches a query with scoring breakdown                                                                                                                         |
| [`_count`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-count)                           | Returns count of documents matching a query without retrieving results                                                                                                                                                  |
| [`_validate/query`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-validate-query) | Validates query syntax without executing the search                                                                                                                                                                     |
| [`_analyze`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze)               | Performs analysis for [full-text search](https://www.elastic.co/docs/solutions/search/full-text) on a text string and returns the resulting tokens.                                                                     |


### Ingestion & mapping APIs


| Endpoint                                                                                                      | Function                                                                       |
|---------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------|
| [`_mapping`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get-field-mapping) | Retrieves or updates field mappings with options for specific field inspection |
| [`_reindex`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-reindex)                   | Copies documents from one index to another, useful for mapping changes         |
| [`_update_by_query`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-update-by-query)   | Updates documents matching a query without reindexing                          |
| [`_bulk`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-bulk)                         | Performs multiple index/update/delete operations in a single request           |
| [`_refresh`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-refresh)           | Forces a refresh to make recent operations searchable                          |
| [`_ingest/pipeline`](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-ingest)                 | Creates and manages document processing pipelines before indexing              |


### Search optimization APIs


| Endpoint                                                                                                  | Function                                                                                                                     |
|-----------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------|
| [`_rank_eval`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-rank-eval)           | Evaluates search quality against known relevant documents                                                                    |
| [`_settings`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get-settings) | Configures settings including slow logs, refresh intervals, and replicas (only index-level settings available in serverless) |
| [`_scripts`](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-script)                     | Creates or updates stored scripts for reuse in queries and aggregations                                                      |


## UI tools


### Dev tools

Access these specialized tools in Kibana and the Serverless UI to develop, debug, and refine your search queries while monitoring their performance and efficiency.
These tools are documented in the **Explore & Analyze** section:

| Tool                                                                                              | Function                                                                                                           |
|---------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------|
| [Saved queries](https://www.elastic.co/docs/explore-analyze/query-filter/tools/saved-queries)     | Save your searches and queries to reuse them later.                                                                |
| [Console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console)                 | Interact with the REST APIs of Elasticsearch and Kibana, including sending requests and viewing API documentation. |
| [Search Profiler](https://www.elastic.co/docs/explore-analyze/query-filter/tools/search-profiler) | Inspect and analyze your search queries.                                                                           |
| [Grok Debugger](https://www.elastic.co/docs/explore-analyze/query-filter/tools/grok-debugger)     | Build and debug grok patterns before you use them in your data processing pipelines.                               |
| [Painless Lab](https://www.elastic.co/docs/explore-analyze/scripting/painless-lab)                | Test and debug Painless scripts in real-time.                                                                      |


## Generative AI tools

The following generative AI tools are available as part of the Elasticsearch solution and serverless project type. They enable you to build AI-powered search applications on top of the core Elasticsearch features, including retrieval augmented generation (RAG) systems and agentic workflows.

### Agent Builder

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
  - Elastic Stack: Preview in 9.2
</applies-to>

[Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/elastic-agent-builder) enables you to create AI agents that can interact with your Elasticsearch data, run queries, and provide intelligent responses. It provides a complete framework for building conversational AI experiences on top of your search infrastructure, including an [MCP server](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/mcp-server).

### Playground

<applies-to>
  - Serverless Elasticsearch projects: Beta
  - Elastic Stack: Beta
</applies-to>

[Playground](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/playground) enables you to use large language models (LLMs) to understand, explore, and analyze your Elasticsearch data using retrieval augmented generation (RAG), via a chat interface. Playground is also useful for testing and debugging your Elasticsearch queries using the [retrievers](https://www.elastic.co/docs/solutions/search/retrievers-overview) syntax with the `_search` endpoint.

### Search UI

[Elastic Search UI](https://www.elastic.co/docs/solutions/search/site-or-app/search-ui) is a library of JavaScript and React tools for building search experiences, optimized for use with Elasticsearch.
<tip>
  Check out the Elasticsearch Labs [blog](https://www.elastic.co/search-labs) to learn how to use Elastic to build advanced search experiences including generative AI, embedding models, reranking capabilities and more.The accompanying [GitHub repository](https://www.github.com/elastic/elasticsearch-labs) contains hands-on Python notebooks and sample apps to help you get started with these advanced search features.
</tip>