﻿---
title: Search use case
description: This section documents core Elasticsearch search capabilities. These capabilities are available across all Elastic deployments, solutions, and project...
url: https://www.elastic.co/docs/solutions/search
products:
  - Elastic Cloud Serverless
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Search use case
This section documents core Elasticsearch search capabilities. These capabilities are available across all Elastic deployments, solutions, and project types.
Use this section to understand search techniques, query methods, ranking strategies, and data ingestion for search-powered applications.
<tip>
  Using the Elasticsearch solution or serverless project type? The [Elasticsearch solution documentation](https://www.elastic.co/docs/solutions/elasticsearch-solution-project) covers additional UI tools included with these options.
</tip>


## What you can build

Use Elasticsearch search capabilities for use cases such as:
- Website and documentation search
- Ecommerce product catalogs
- Content recommendation systems
- RAG (Retrieval Augmented Generation) systems
- Geospatial search applications
- Question answering systems
- Analytics dashboards and data exploration
- Custom observability or cybersecurity search tools
- Much more!


## Search use case documentation

The following subjects are covered in this section:

| Topic                                                                                      | Description                                                                                                    |
|--------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------|
| [**Get started**](https://www.elastic.co/docs/solutions/search/get-started)                | Create deployments, connect to Elasticsearch, and run your first searches                                      |
| [**Ingest data**](https://www.elastic.co/docs/solutions/search/ingest-for-search)          | Learn about options for getting data into Elasticsearch for search use cases                                   |
| [**Search approaches**](https://www.elastic.co/docs/solutions/search/search-approaches)    | Compare search techniques available in Elasticsearch, including full-text, vector, semantic, and hybrid search |
| [**Build your queries**](https://www.elastic.co/docs/solutions/search/querying-for-search) | Implement your search approaches using specific query languages                                                |
| [**Ranking and reranking**](https://www.elastic.co/docs/solutions/search/ranking)          | Control result ordering and relevance                                                                          |
| [**RAG**](https://www.elastic.co/docs/solutions/search/rag)                                | Learn about tools for retrieval augmented generation with Elasticsearch                                        |
| [**Building applications**](https://www.elastic.co/docs/solutions/search/site-or-app)      | Integrate Elasticsearch into your websites or applications                                                     |


## Search concepts

For an introduction to core Elasticsearch concepts such as indices, documents, and mappings, refer to [The Elasticsearch data store](https://www.elastic.co/docs/manage-data/data-store).
To dive more deeply into the building blocks of Elasticsearch clusters, including nodes, shards, primaries, and replicas, refer to [Distributed architecture](https://www.elastic.co/docs/deploy-manage/distributed-architecture).

## Related reference

- [Elasticsearch reference documentation](https://www.elastic.co/docs/reference/elasticsearch)
- [Elasticsearch API documentation](https://www.elastic.co/docs/api/doc/elasticsearch/)