﻿---
title: View monitor status
description: The Monitors page provides you with a high-level view of all the services you are monitoring to help you quickly diagnose outages and other connectivity...
url: https://www.elastic.co/docs/solutions/observability/uptime/view-monitor-status
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Deprecated since 8.15
---

# View monitor status
<admonition title="Deprecated in 8.15.0.">
  Use [Synthetic monitoring](https://www.elastic.co/docs/solutions/observability/synthetics) instead of the Uptime app.
</admonition>

The **Monitors** page provides you with a high-level view of all the services you are monitoring to help you quickly diagnose outages and other connectivity issues within your network.
To access this page, go to **Observability > Uptime > Monitors**.
<important>
  Each endpoint, URL, and service represents a *monitor*.
</important>


## Filter monitors

To get started with your analysis, use the automated filter options, such as location, port, scheme, and tags, or define a custom filter by field, URL, monitor ID, and other attributes.
![Uptime filter bar](https://www.elastic.co/docs/solutions/images/observability-uptime-filter-bar.png)


## Monitor availability

The snapshot panel displays the overall status of the environment you’re monitoring or a subset of those monitors. You can see the total number of detected monitors within the selected date range, based on the last check reported by Heartbeat, along with the number of monitors in an `up` or `down` state.
Next to the counts, a histogram shows a count of **Pings over time** with a breakdown of `Up` and `Down` counts per time bucket.
![Monitors chart](https://www.elastic.co/docs/solutions/images/observability-monitors-chart.png)

Information about individual monitors is displayed in the monitor list and provides a quick way to navigate to a detailed visualization for hosts or endpoints.
The information displayed includes the recent status of a host or endpoint, when the monitor was last checked, its URL, and, if applicable, the TLS certificate expiration time. There is also a sparkline showing downtime history.
<tip>
  Use monitor tags to display a custom assortment of monitors; for example, consider assigning tags based on a monitor’s hosted cloud provider – making it easy to quickly see all monitors hosted on GCP, AWS, etc.
</tip>

Expand the table row for a specific monitor on the list to view additional information such as which alerts are configured for the monitor, a recent error and when it occurred, the date and time of any recent test runs, and it’s URL.
![Monitors list](https://www.elastic.co/docs/solutions/images/observability-monitors-list.png)


## Integrate with other Observability apps

The Monitor list also contains a menu of available integrations. Expand the table row for a specific monitor on the list, and then click **Investigate**.
Depending on the features you have installed and configured, you can view logs, metrics, or APM data relating to that monitor. You can choose:
- Show host, pod, or container logs in the [Logs app](https://www.elastic.co/docs/solutions/observability/logs/explore-logs).
- Show APM data in the [Applications UI](https://www.elastic.co/docs/solutions/observability/apm/traces-ui).
- Show host, pod, or container metrics in the [Infrastructure app](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics).