﻿---
title: Inspect uptime duration anomalies
description: Each monitor location is modeled, and when a monitor runs for an unusual amount of time, at a particular time, an anomaly is recorded and highlighted...
url: https://www.elastic.co/docs/solutions/observability/uptime/inspect-duration-anomalies
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Deprecated since 8.15
---

# Inspect uptime duration anomalies
<admonition title="Deprecated in 8.15.0.">
  Use [Synthetic monitoring](https://www.elastic.co/docs/solutions/observability/synthetics) instead of the Uptime app.
</admonition>

Each monitor location is modeled, and when a monitor runs for an unusual amount of time, at a particular time, an anomaly is recorded and highlighted on the **Monitor duration** chart.

## Enable uptime duration anomaly detection

Create a machine learning job to detect anomalous monitor duration rates automatically.
1. To access this page, go to **Observability > Uptime > Monitors**, and then click a monitor to view its the details.
2. In the **Monitor duration** panel, click **Enable anomaly detection**.
   <note>
   If anomaly detection is already enabled, click **Anomaly detection** and select to view duration anomalies directly in the [Machine Learning app](/docs/explore-analyze/machine-learning/anomaly-detection/ml-getting-started#sample-data-results), enable an [anomaly rule](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-uptime-duration-anomaly-rule), or disable the anomaly detection.
   </note>
3. You are prompted to create a [response duration anomaly rule](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-uptime-duration-anomaly-rule) for the machine learning job which will carry out the analysis, and you can configure which severity level to create the rule for.

When an anomaly is detected, the duration is displayed on the **Monitor duration** chart, along with the duration times. The colors represent the criticality of the anomaly: red (critical) and yellow (minor).
![inspect uptime duration anomalies](https://www.elastic.co/docs/solutions/images/observability-inspect-uptime-duration-anomalies.png)