﻿---
title: Get started with Uptime
description: Heartbeat is a lightweight daemon that you install on a remote server to periodically check the status of your services and determine if they are available...
url: https://www.elastic.co/docs/solutions/observability/uptime/get-started
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Deprecated since 8.15
---

# Get started with Uptime
<admonition title="Deprecated in 8.15.0.">
  Use [Synthetic monitoring](https://www.elastic.co/docs/solutions/observability/synthetics) instead of the Uptime app.
</admonition>

<important>
  **This approach can only be used to create lightweight monitors.** To create *browser* monitors, use the [Synthetics app](https://www.elastic.co/docs/solutions/observability/synthetics/get-started).
</important>

Heartbeat is a lightweight daemon that you install on a remote server to periodically check the status of your services and determine if they are available. It gathers performance data, formats it, and sends the data to the Elastic Stack.
![Diagram showing which pieces of software are used to configure monitors](https://www.elastic.co/docs/solutions/images/observability-synthetics-get-started-heartbeat.png)

<note>
  The Elastic Synthetics integration is a method for creating synthetic monitors that is no longer recommended. **Do not use the Elastic Synthetics integration to set up new monitors.**For details on how to migrate from Elastic Synthetics integration to project monitors or the Synthetics app, refer to [Migrate from the Elastic Synthetics integration](https://www.elastic.co/docs/solutions/observability/synthetics/migrate-from-elastic-synthetics-integration).If you’ve used the Elastic Synthetics integration to create monitors in the past and need to reference documentation about the integration, go to the [8.3 documentation](https://www.elastic.co/guide/en/observability/8.3/uptime-set-up.html#uptime-set-up-choose-agent).
</note>


## Pull the Docker image

Elastic provides Docker images that you can use to run monitors. Start by pulling the Heartbeat Docker image.
```sh
docker pull docker.elastic.co/beats/heartbeat:9.3.0
```


## Configure

Next, create a `heartbeat.yml` configuration file.
The example below shows how to configure an `http` monitor, one of [three types of lightweight monitors](https://www.elastic.co/docs/reference/beats/heartbeat/configuration-heartbeat-options#monitor-types).
```yaml
heartbeat.monitors:
- type: http
  id: service-status 
  name: Service Status
  service.name: my-apm-service-name
  hosts: ["http://localhost:80/service/status"]
  check.response.status: [200]
  schedule: '@every 5s'
```

Read more about configuration options in [Configure Heartbeat monitors](https://www.elastic.co/docs/reference/beats/heartbeat/configuration-heartbeat-options).
<warning>
  **Do not use Heartbeat to set up a *new* `browser` monitor.** Instead, use the [Synthetics app](https://www.elastic.co/docs/solutions/observability/synthetics/get-started).If you previously used Heartbeat to set up **`browser`** monitor, you can find resources in the [8.4 Heartbeat documentation](https://www.elastic.co/guide/en/beats/heartbeat/8.4/monitor-browser-options.html).
</warning>


## Connect to the Elastic Stack

After configuring the monitor, run it in Docker and connect the monitor to the Elastic Stack.
You'll need to retrieve your Elasticsearch credentials for either an [Elastic Cloud ID](https://www.elastic.co/docs/reference/beats/heartbeat/configure-cloud-id) or another [Elasticsearch Cluster](https://www.elastic.co/docs/reference/beats/heartbeat/elasticsearch-output).
The example below, shows how to run synthetics tests indexing data into Elasticsearch.
You'll need to insert your actual `cloud.id` and `cloud.auth` values to successfully index data to your cluster.
```sh
docker run \
  --rm \
  --name=heartbeat \
  --user=heartbeat \
  --volume="$PWD/heartbeat.yml:/usr/share/heartbeat/heartbeat.yml:ro" \
  --cap-add=NET_RAW \
  docker.elastic.co/beats/heartbeat:9.3.0 heartbeat -e \
  -E cloud.id={cloud-id} \
  -E cloud.auth=elastic:{cloud-pass}
```

If you aren't using Elastic Cloud, replace `-E cloud.id` and `-E cloud.auth` with your Elasticsearch hosts,
username, and password:
```sh
docker run \
  --rm \
  --name=heartbeat \
  --user=heartbeat \
  --volume="$PWD/heartbeat.yml:/usr/share/heartbeat/heartbeat.yml:ro" \
  --cap-add=NET_RAW \
  docker.elastic.co/beats/heartbeat:9.3.0 heartbeat -e \
  -E output.elasticsearch.hosts=["localhost:9200"] \
  -E output.elasticsearch.username=elastic \
  -E output.elasticsearch.password=changeme
```

Note the `--volume` option, which mounts local directories into the
container. Here, we mount the `heartbeat.yml` from the working directory,
into Heartbeat's expected location for `heartbeat.yml`.
<warning>
  Elastic Synthetics runs Chromium without the extra protection of its process
  [sandbox](https://chromium.googlesource.com/chromium/src/+/master/docs/linux/sandboxing.md)
  for greater compatibility with Linux server distributions.
  Add the `sandbox: true` option to a given browser monitor in Heartbeat to enable sandboxing.
  This may require using a custom seccomp policy with docker, which brings its own added risks.
  This is generally safe when run against sites whose content you trust,
  and with a recent version of Elastic Synthetics and Chromium.
</warning>


## View in Kibana

Heartbeat is now sending synthetic monitoring data to the Elastic Stack. Navigate to the Uptime app in Kibana, where you can see screenshots of each run, set up alerts in case of test failures, and more.
If a test does fail (shown as `down` in the Uptime app), you’ll be able to view the step script that failed, any errors, and a stack trace. For more information, refer to [Analyze](https://www.elastic.co/docs/solutions/observability/uptime/analyze).

## Manage monitors

After you’ve created a monitor, you’ll need to manage that monitor over time. This might include updating or permanently deleting an existing monitor.
To update a monitor’s configuration, update the relevant options in the Heartbeat configuration file, and the changes will be reflected in the monitors.
To permanently delete a monitor, delete the monitor entry in the `heartbeat.yml` file.