﻿---
title: Configure Uptime monitoring settings
description: The Settings page enables you to change which Heartbeat indices are displayed by the Uptime app, configure rule connectors, and set expiration/age thresholds...
url: https://www.elastic.co/docs/solutions/observability/uptime/configure-settings
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Deprecated since 8.15
---

# Configure Uptime monitoring settings
<admonition title="Deprecated in 8.15.0.">
  Use [Synthetic monitoring](https://www.elastic.co/docs/solutions/observability/synthetics) instead of the Uptime app.
</admonition>

The **Settings** page enables you to change which Heartbeat indices are displayed by the Uptime app, configure rule connectors, and set expiration/age thresholds for TLS certificates.
Uptime settings apply to the current space only. To segment different uptime use cases and domains, use different settings in other spaces.
1. To access this page, go to **Observability > Uptime**.
2. At the top of the page, click **Settings**.
   <important>
   To modify items on this page, you must have the [`all`](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) Uptime privilege granted to your role.
   </important>


## Configure indices

Specify a comma-separated list of index patterns to match indices in Elasticsearch that contain Heartbeat data.
<note>
  The pattern set here only restricts what the Uptime app displays. You can still query Elasticsearch for data outside of this pattern.
</note>

![Heartbeat indices](https://www.elastic.co/docs/solutions/images/observability-heartbeat-indices.png)


## Configure connectors

**Alerts** work by running checks on a schedule to detect conditions defined by a rule. When a condition is met, the rule tracks it as an **alert** and responds by triggering one or more **actions**. Actions typically involve interaction with Kibana services or third party integrations. **Connectors** allow actions to talk to these services and integrations.
Click **Create connector** and follow the prompts to select a connector type and configure its properties. After you create a connector, it’s available to you anytime you set up a rule action in the current space.
For more information about each connector, see [action types and connectors](https://www.elastic.co/docs/deploy-manage/manage-connectors).
![Rule connector](https://www.elastic.co/docs/solutions/images/observability-alert-connector.png)


## Configure certificate thresholds

You can modify certificate thresholds to control how Uptime displays your TLS values in the [TLS Certificates](/docs/solutions/observability/uptime#view-certificate-status) page. These settings also determine which certificates are selected by any TLS rule you create.

|                          |                                                                                                                                                                                                                                                                                                                                                                                                                                        |
|--------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Expiration threshold** | The `expiration` threshold specifies when you are notifiedabout certificates that are approaching expiration dates. When the value of a certificate’s remaining valid days fallsbelow the `Expiration threshold`, it’s considered a warning state. When you define a[TLS rule](https://www.elastic.co/docs/solutions/observability/incident-management/create-tls-certificate-rule), you receive a notification about the certificate. |
| **Age limit**            | The `age` threshold specifies when you are notified about certificatesthat have been valid for too long.                                                                                                                                                                                                                                                                                                                               |

A standard security requirement is to make sure that your TLS certificates have not been valid for longer than a year. To help you keep track of which certificates you may want to refresh, modify the **Age limit** value to `365` days.
![Certificate expiry settings](https://www.elastic.co/docs/solutions/images/observability-cert-expiry-settings.png)